<?php
//       FamAndSub
// Build, Sort and make dom
//     of Family/Sub
//
function FamAndSub_Build($visitor, $prefix, &$arr){
	$fam = @$visitor->getElementsByTagName($prefix."fam")->item(0)->nodeValue;
	$name = @$visitor->getElementsByTagName($prefix."nam")->item(0)->nodeValue;
	$icon = @$visitor->getElementsByTagName($prefix."ico")->item(0)->nodeValue;
	
	//mit Subverson
	if(!isset($arr[$fam][$name]['count'])){
		$arr[$fam][$name]['count'] = 1;
	}else{
		$arr[$fam][$name]['count'] = $arr[$fam][$name]['count'] + 1;
	}
					
	//Ohne Sub, nur Anzahl
	if(!isset($arr[$fam]['all']['count'])){
		$arr[$fam]['all']['count'] = 1;
	}else{
		$arr[$fam]['all']['count'] = $arr[$fam]['all']['count'] + 1;
	}
	//letztes Icon!
	$arr[$fam]['all']['icon'] = $icon;
	$arr[$fam][$name]['icon'] = $icon;
}


function FamAndSub_Sort(&$arr){
	$tmp_sort = array();
	
	//sort Counter:
	foreach($arr as $key => $row) {
		$tmp_sort[$key]  = $row['all']['count'];
	}
	array_multisort($tmp_sort, SORT_DESC, $arr);

	//sort of versions:
	foreach($arr as $arr2 => $temp2){
		krsort($arr[$arr2]);
	}
	unset($tmp_sort);
}


function FamAndSub_DOM(&$doc, &$root, $arr){
	foreach($arr as $fam => $inhalt){
		$typadd = $doc->createElement("typ");
		$typadd->setAttribute("name", $fam);
			foreach($inhalt as $subname => $data){
				if($subname == "all"){continue;}
				$subtypadd = $doc->createElement("sub");
				$subtypadd->setAttribute("version", $subname);
					$subtypadd->appendChild($doc->createElement("count", $data["count"]));
					$subtypadd->appendChild($doc->createElement("icon", $data["icon"]));
				$typadd->appendChild($subtypadd);
			}
				$alladd = $doc->createElement("all");
				$alladd->appendChild($doc->createElement("count", $inhalt["all"]["count"]));
				$alladd->appendChild($doc->createElement("icon", $inhalt["all"]["icon"]));
			$typadd->appendChild($alladd);
		$root->appendChild($typadd);
	}
}


//      Normal
// Build, Sort and make dom
//     of only family
//

function Normal_Build($visitor, $tag, &$arr, $icontag = NULL, $icon = false){
	$name = @$visitor->getElementsByTagName($tag)->item(0)->nodeValue;
	if($icon == true){
		$icon = @$visitor->getElementsByTagName($icontag)->item(0)->nodeValue;
	}
	
	if(isset($name) and $name != ""){
		if(!isset($arr[$name]['count'])){
			$arr[$name]['count'] = 1;
		}else{
			$arr[$name]['count'] = $arr[$name]['count'] + 1;
		}
		
		if($icon == true){
			$arr[$name]['icon'] = $icon;
		}
	}
}


function Normal_Sort(&$arr){
	$tmp_sort = array();
	
	foreach($arr as $key => $row) {
		$tmp_sort[$key]  = $row['count'];
	}
	array_multisort($tmp_sort, SORT_DESC, $arr);
	
	unset($tmp_sort);
}


function Normal_DOM(&$doc, &$root, $arr, $subname = "typ", $subvalname = "name", $icon = false){
	foreach($arr as $name => $sub){
		$add = $doc->createElement($subname);
		$add->setAttribute($subvalname, $name);
			$add->appendChild($doc->createElement("count", $sub['count']));
			if($icon == true){
			$add->appendChild($doc->createElement("icon", $sub['icon']));
			}
		$root->appendChild($add);
	}
}


//       Time
//       Build
// the timefunction
//
function Time_Build($visitor, &$arr, $typ){
	$timestr = @$visitor->getElementsByTagName("uti")->item(0)->nodeValue;
	$time = date("G", $timestr);//hier kein gmdate, da hier das erste mal konvertiert wird :P
	$t_index = str_pad($time,2,"0",STR_PAD_LEFT).":00-".str_pad(($time+1),2,"0",STR_PAD_LEFT).":00";
	
	
	if($typ == "Robot" or $typ == "Validator"){
		$writetyp = "bots";
	}else{
		$writetyp = "people";
	}
	
	if(!isset($arr[$t_index][$writetyp])){
		$arr[$t_index][$writetyp] = 1;
	}else{
		$arr[$t_index][$writetyp] = $arr[$t_index][$writetyp] + 1;
	}
	
	if(!isset($arr['all'][$writetyp])){
		$arr['all'][$writetyp] = 1;
	}else{
		$arr['all'][$writetyp] = $arr['all'][$writetyp] + 1;
	}
}


//           BotPeople
//        sort and make dom
// of array with Fam and Bots/People
//
function BotPeople_Sort(&$arr){
	$tmp_sort = array();
	
	foreach($arr as $key => $row) {
		$tmp_sort[$key] = $key;
	}
	array_multisort($tmp_sort, SORT_ASC, $arr);
	
	unset($tmp_sort);
}


function BotPeople_DOM(&$doc, &$root, $arr, $subname = "typ", $subvalname = "name"){
	foreach($arr as $name => $sub){
		if($name != "all"){
			$add = $doc->createElement($subname);
			$add->setAttribute($subvalname, $name);
				if(isset($sub['bots'])){
					$add->appendChild($doc->createElement("bots", $sub['bots']));
				}else{
					$add->appendChild($doc->createElement("bots", "0"));
				}
				if(isset($sub['people'])){
					$add->appendChild($doc->createElement("people", $sub['people']));
				}else{
					$add->appendChild($doc->createElement("people", "0"));
				}
			$root->appendChild($add);
		}
	}
	
	$gesamtadd = $doc->createElement("total");
	$gesamtadd->appendChild($doc->createElement("bots", $arr['all']['bots']));
	$gesamtadd->appendChild($doc->createElement("people", $arr['all']['people']));

	$root->appendChild($gesamtadd);
	
}


?>