﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Web.Mvc;
using PluginTest.Plugins.Agenda.Models;

namespace PluginTest.Plugins.Agenda.Controllers
{
    public class AgendaController : Controller
    {
        public ActionResult Index(DateTime? startDate, int dayCount = 1)
        {
            startDate = startDate ?? DateTime.Now;
            DateTime endDate = startDate.Value.Date.AddDays(dayCount).AddSeconds(-1);

            var allAgendas = GetAgendas();
            var model = new List<AgendaModel>();

            DateTime currentDate = startDate.Value.Date;
            while (currentDate <= endDate)
            {
                model.Add(new AgendaModel
                              {
                                  PlanningDate = currentDate,
                                  Agendas = allAgendas.Where(a => a.PlanningDate.Date.Equals(currentDate.Date)).OrderBy(a => a.PlanningDate).ToList()
                              });
                currentDate = currentDate.AddDays(1);
            }

            return PartialView(model);
        }

        #region Private

        private IEnumerable<AgendaDto> GetAgendas()
        {
            DateTime date = DateTime.Now.Date;

            return new List<AgendaDto>()
                       {
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddHours(9), 
                                   Title = "Scrum meeting", 
                                   Description =@"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum turpis at justo scelerisque et scelerisque eros fermentum. Etiam sed purus vitae tortor porta pulvinar. Pellentesque habitant morbi"},
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddHours(10),
                                   Title = "Team meeting", 
                                   Description = "Nulla malesuada ante vel ante ultricies tincidunt"
                               },
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(1).AddHours(11), 
                                   Title = "Sales meeting",
                                   Description = "Phasellus porta bibendum turpis, eget dictum massa adipiscing in. Integer mattis tempor tellus malesuada bibendum"
                               },
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(1).AddHours(9), 
                                   Title = "Scrum meeting", 
                                   Description =@"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum turpis at justo scelerisque et scelerisque eros fermentum. Etiam sed purus vitae tortor porta pulvinar. Pellentesque habitant morbi"},
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(1).AddHours(13),
                                   Title = "Product management meeting", 
                                   Description = "Aliquam vehicula leo ut nisl consectetur vitae dictum nulla eleifend. Nullam euismod, neque vel vestibulum rhoncus, orci tellus posuere risus, vel hendrerit magna elit sed sapien"},
                            new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(2).AddHours(14), 
                                   Title = "Code review",
                                   Description = "Nulla orci felis, viverra non mollis et, tincidunt vel magna. Pellentesque risus turpis, ultrices eget iaculis id, imperdiet ut purus. Curabitur a elit eget dui lobortis cursus ac non ipsum."
                               },
                          new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(3).AddHours(9), 
                                   Title = "Scrum meeting", 
                                   Description =@"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum turpis at justo scelerisque et scelerisque eros fermentum. Etiam sed purus vitae tortor porta pulvinar. Pellentesque habitant morbi"},
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(4).AddHours(9),
                                   Title = "Scrum meeting", 
                                   Description = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum turpis at justo scelerisque et scelerisque eros fermentum. Etiam sed purus vitae tortor porta pulvinar. Pellentesque habitant morbi"},
                           new AgendaDto
                               {
                                   Id = Guid.NewGuid(), 
                                   PlanningDate = date.AddDays(5).AddHours(9), 
                                   Title = "Scrum meeting",
                                   Description = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum turpis at justo scelerisque et scelerisque eros fermentum. Etiam sed purus vitae tortor porta pulvinar. Pellentesque habitant morbi"
                               }
                       };
        }

        #endregion
    }

     
}
