﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Web.Mvc;
using PluginTest.Plugins.News.Models;

namespace PluginTest.Plugins.News.Controllers
{
    public class NewsController : Controller
    {
        public ActionResult Index(DateTime? startDate, int dayCount = 1)
        {
            startDate = startDate ?? DateTime.Now;
            DateTime endDate = startDate.Value.Date.AddDays(dayCount);

            var allNews = GetNews();
            var model = allNews.Where(m => m.StartDate <= startDate && m.EndDate > endDate);
            return PartialView(model);
        }

        #region Private

        private IEnumerable<NewsModel> GetNews()
        {
            DateTime startDate =  DateTime.Now.Date;
            DateTime endDate =  DateTime.Now.AddDays(7).Date.AddSeconds(-1);

            return new List<NewsModel>()
                       {
                           new NewsModel
                               {
                                   Id = Guid.NewGuid(), 
                                   StartDate = startDate, 
                                   EndDate = endDate, 
                                   Title = "Lorem ipsum dolor sit amet ...", 
                                   Description = 
@"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam nec lorem dui. Fusce vel imperdiet nunc. Etiam dapibus consectetur nibh ut feugiat. Fusce condimentum ante at est aliquam commodo scelerisque purus venenatis. Cras mi risus, consectetur nec egestas id, porta ac dolor. Phasellus imperdiet feugiat augue, a iaculis sem sagittis et. Aenean dignissim sapien bibendum quam volutpat aliquet vel a purus. Maecenas placerat ultricies metus. Cras venenatis tempor mi sit amet volutpat. Nulla at adipiscing augue. Vestibulum posuere dolor eget massa aliquet rhoncus.


Proin pretium laoreet justo, eu tristique eros euismod ut. Sed in pulvinar lectus. Mauris porta tristique interdum. In hac habitasse platea dictumst. Integer nisi turpis, auctor vel posuere vitae, pharetra non ligula. Nullam leo tellus, porta sit amet rhoncus eget, commodo blandit orci. Ut ut arcu magna, vel semper nisl. Donec at tempus velit. Nam euismod convallis sollicitudin. Nullam sagittis elit at risus imperdiet lacinia. Pellentesque eros est, dictum nec aliquam non, molestie a magna. Donec libero tellus, venenatis id varius sed, tristique ut augue. Pellentesque sit amet ligula diam, eu viverra quam. Ut orci ante, sagittis sed tincidunt gravida, dapibus at neque."
                               },
                           new NewsModel
                               {
                                   Id = Guid.NewGuid(), 
                                   StartDate = startDate, 
                                   EndDate = endDate, 
                                   Title = "Cras pellentesque ...", 
                                   Description = 
@"Cras pellentesque, quam vitae elementum euismod, erat sem euismod massa, quis vulputate mi justo eget lacus. Vestibulum vel fringilla purus. Cras quis consequat orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vestibulum nec turpis eu erat semper lobortis sit amet ac leo. Donec ipsum orci, bibendum id euismod tempus, interdum vitae sapien. Donec vitae purus eu massa ornare varius. Duis cursus, lectus eu auctor luctus, sem velit adipiscing sapien, vitae lacinia nisl libero ac turpis. Aliquam erat volutpat. Nulla facilisi.


Donec ultrices pellentesque libero at cursus. Suspendisse condimentum dignissim enim luctus tincidunt. In ac urna ligula, id ultrices lectus. Nullam nec elit sem, a vestibulum augue. Integer interdum libero eget justo posuere sed molestie felis condimentum. Nulla vel dolor vitae urna imperdiet commodo. Praesent nec tellus tellus. Aenean in tristique nibh. Ut ante diam, commodo sit amet dictum ac, semper ultricies metus. Curabitur in nulla urna. Quisque commodo, lectus a ullamcorper malesuada, dui ligula sagittis quam, non volutpat dolor est ut neque. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam nec nulla diam, vulputate elementum risus. Vivamus in ante at sapien euismod laoreet quis id tellus. Mauris tristique placerat mi, at ultrices magna vulputate sed."
                               },
                                new NewsModel
                               {
                                   Id = Guid.NewGuid(), 
                                   StartDate = startDate, 
                                   EndDate = endDate, 
                                   Title = "Morbi mattis ...", 
                                   Description = 
@"Morbi mattis, tortor vitae adipiscing fringilla, justo nisl dignissim nulla, vel accumsan diam mi nec sem. Vestibulum pellentesque scelerisque dui, vel dignissim augue sollicitudin vel. Donec pulvinar euismod congue. Suspendisse sagittis orci at tortor tincidunt eleifend. Maecenas risus mauris, placerat vel egestas sit amet, vestibulum et est. Vivamus in neque at tortor eleifend posuere vel at metus. Integer a dolor id ante rhoncus pretium sit amet ut tortor. Nulla vulputate ornare diam, non congue nisi tincidunt in. Ut dignissim condimentum nunc, vitae lobortis ipsum egestas quis. Etiam vulputate pretium commodo. Morbi turpis massa, feugiat id egestas dignissim, tincidunt a arcu."
                               }
                       };
        }

        #endregion
    }
}
