﻿using System;
using System.Web.Mvc;
using PluginTest.Plugins.Calendar.Models;

namespace PluginTest.Plugins.Calendar.Controllers
{
    public class CalendarItemController : Controller
    {
        public ActionResult Index(DateTime? startDate, int dayCount = 1)
        {
            startDate = startDate ?? DateTime.Now;
            DateTime endDate = startDate.Value.Date.AddDays(dayCount).AddSeconds(-1);
            return PartialView(new CalendarItemModel { StartDate = startDate.Value, DayCount = dayCount });
        }
    }
}
