﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page
{
    protected int currentPageNumber = 1;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            HdnID.Value = "0";
            BindData();
        }
    }
    protected void BindData()
    {
        string keyWord = txtKeyWord.Text.Trim();
        using (SqlConnection con = new SqlConnection(System.Web.Configuration.WebConfigurationManager.ConnectionStrings["SqlConnection"].ConnectionString))
        {
            con.Open();
            DataTable dtFiles = new DataTable();
            SqlCommand com = new SqlCommand("SP_GetUserDetails", con);
            com.CommandType = CommandType.StoredProcedure;
            com.Parameters.AddWithValue("@keyword", keyWord);
            com.Parameters.AddWithValue("@startRowIndex", currentPageNumber);
            com.Parameters.AddWithValue("@maximumRows", Convert.ToInt32(ddlPageSize.SelectedValue.Trim()));
            com.Parameters.Add("@totalRows", SqlDbType.Int, 4);
            com.Parameters["@totalRows"].Direction = ParameterDirection.Output;
            SqlDataAdapter da = new SqlDataAdapter();
            da.SelectCommand = com;
            da.Fill(dtFiles);
            GridViewUsers.PageSize = 20;
            GridViewUsers.DataSource = dtFiles;
            GridViewUsers.DataBind();
            double totalRows = (int)com.Parameters["@totalRows"].Value;
            if (totalRows == 0)
            {
                DisableButton(Btn_Previous);
                DisableButton(Btn_Next);
                lblTotalPages.Text = "0";
                lblCurrentPage.Text = "0";
            }
            else
            {
                lblTotalPages.Text = CalculateTotalPages(totalRows).ToString();
                lblCurrentPage.Text = currentPageNumber.ToString();
                if (currentPageNumber == 1)
                {
                    DisableButton(Btn_Previous);
                    if (Int32.Parse(lblTotalPages.Text) > 1)
                    {
                        EnableButtoon(Btn_Next);
                    }
                    else
                    {
                        DisableButton(Btn_Next);
                    }
                }
                else
                {
                    EnableButtoon(Btn_Previous);
                    if (currentPageNumber == Int32.Parse(lblTotalPages.Text))
                    {
                        DisableButton(Btn_Next);
                    }
                    else
                    {
                        EnableButtoon(Btn_Next);
                    }
                }
            }
        }
        if (GridViewUsers.Rows.Count > 0)
        {
            GridViewUsers.UseAccessibleHeader = true;
            GridViewUsers.HeaderRow.TableSection = TableRowSection.TableHeader;
            GridViewUsers.FooterRow.TableSection = TableRowSection.TableFooter;
        }
    }
    private int CalculateTotalPages(double totalRows)
    {
        int totalPages = (int)Math.Ceiling(totalRows / Convert.ToInt32(ddlPageSize.SelectedValue.Trim()));
        return totalPages;
    }
    protected void GridViewUsers_RowCommand(object sender, GridViewCommandEventArgs e)
    {

    }
    protected string SetImage(string condition)
    {
        string result = "";
        result = condition == "True" ? "<img src=\"Images/icon_include.png\" alt=\"Yes\" />" : "<img src=\"Images/icon_cross.png\" alt=\"No\" />";
        return result;
    }
    protected void EnableButtoon(Button btn)
    {
        btn.Enabled = true;
        btn.CssClass = "appButtonNavigationEnabled";
    }
    protected void DisableButton(Button btn)
    {
        btn.Enabled = false;
        btn.CssClass = "appButtonNavigationDisabled";
    }
    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
        BindData();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        string recordsToBeDeleted = "";
        foreach (GridViewRow gvr in GridViewUsers.Rows)
        {
            if (gvr.RowType == DataControlRowType.DataRow)
            {
                CheckBox chkDelete = (CheckBox)gvr.FindControl("CheckBoxEmployeeID");
                if (chkDelete.Checked)
                {
                    string recordID = GridViewUsers.DataKeys[gvr.RowIndex].Values[0].ToString();
                    recordsToBeDeleted += recordID.Trim() + ",";
                }
            }
        }
        if (recordsToBeDeleted != "")
        {
            try
            {
                using (SqlConnection con = new SqlConnection(System.Web.Configuration.WebConfigurationManager.ConnectionStrings["SqlConnection"].ConnectionString))
                {
                    con.Open();
                    SqlCommand com = new SqlCommand("SP_DeleteUserDetails", con);
                    com.CommandType = CommandType.StoredProcedure;
                    com.Parameters.AddWithValue("@idlist", recordsToBeDeleted);
                    com.ExecuteNonQuery();
                    currentPageNumber = 1;
                    BindData();
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "Delete", "alert('Record(s) deleted.');", true);
                }
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "Delete", "alert('There was an error. Please try again later.');", true);
            }
        }
    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {

    }
    protected void Btn_Next_Click(object sender, EventArgs e)
    {
        currentPageNumber = Int32.Parse(lblCurrentPage.Text) + 1;
        BindData();
    }
    protected void Btn_Previous_Click(object sender, EventArgs e)
    {
        currentPageNumber = Int32.Parse(lblCurrentPage.Text) - 1;
        BindData();
    }
    protected void GridViewUsers_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            DataRowView rowView = (DataRowView)e.Row.DataItem;
            string rowID = rowView["ED_ID"].ToString();
            Label linkDetails = new Label();
            Button btnEditRow = new Button();
            linkDetails = (Label)e.Row.FindControl("linkDetails");
            btnEditRow = (Button)e.Row.FindControl("btnEditRow");
            linkDetails.Attributes.Add("onclick", "getDetails('" + rowID + "');");
            btnEditRow.Attributes.Add("onclick", "return getDetailsToEdit('" + rowID + "');");
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string _mode = hdnMode.Value.Trim();
        string fileName = "";
        string fileExtension = "";
        bool isFileUplaoded = false;
        if (FileUploadUserImage.HasFile)
        {
            isFileUplaoded = true;
            fileExtension = System.IO.Path.GetExtension(FileUploadUserImage.PostedFile.FileName);
            fileName = Guid.NewGuid().ToString().Replace("-", "").ToUpper() + fileExtension;
            string upLoadPath = Server.MapPath("./UserImages/") + fileName;
            FileUploadUserImage.SaveAs(upLoadPath);
        }
        int id = Convert.ToInt32(HdnID.Value);
        string userID = TextBoxUserID.Text.Trim();
        string firstName = TextBoxFirstName.Text.Trim();
        string lastName = TextBoxLastName.Text.Trim();
        DateTime dateOfBirth = Convert.ToDateTime(TextBoxDOB.Text.Trim());
        string cellPhoneNumber = TextBoxCellNumber.Text.Trim();
        string landLineNumber = TextBoxLandlineNumber.Text.Trim();
        string emailID = TextBoxEMailID.Text.Trim();
        string address = TextBoxAddress.Text.Trim();
        string experience = TextBoxExperience.Text.Trim();
        string skills = TextBoxSkills.Text.Trim();
        string designation = TextBoxDesignation.Text.Trim();
        string previousCompany = TextBoxPreviousCompany.Text.Trim();
        DateTime dateOfJoining = Convert.ToDateTime(TextBoxDOJ.Text.Trim());
        bool isReportingManager = CheckBoxIsReportingManager.Checked;
        bool isPermanent = CheckBoxIsPermanent.Checked;
        using (SqlConnection con = new SqlConnection(System.Web.Configuration.WebConfigurationManager.ConnectionStrings["SqlConnection"].ConnectionString))
        {
            con.Open();
            SqlCommand com = new SqlCommand("SP_AddUpdateUserDetails", con);
            com.CommandType = CommandType.StoredProcedure;
            com.Parameters.AddWithValue("@mode", _mode);
            com.Parameters.AddWithValue("@isfileuploaded", isFileUplaoded);
            com.Parameters.AddWithValue("@id", id);
            com.Parameters.AddWithValue("@edcode", userID);
            com.Parameters.AddWithValue("@firstname", firstName);
            com.Parameters.AddWithValue("@lastname", lastName);
            com.Parameters.AddWithValue("@dateofbirth", dateOfBirth);
            com.Parameters.AddWithValue("@cellphonenumber", cellPhoneNumber);
            com.Parameters.AddWithValue("@landlinenumber", landLineNumber);
            com.Parameters.AddWithValue("@emailid", emailID);
            com.Parameters.AddWithValue("@address", address);
            com.Parameters.AddWithValue("@imagepath", fileName);
            com.Parameters.AddWithValue("@experience", experience);
            com.Parameters.AddWithValue("@skills", skills);
            com.Parameters.AddWithValue("@designation", designation);
            com.Parameters.AddWithValue("@previouscompany", previousCompany);
            com.Parameters.AddWithValue("@dateofjoining", dateOfJoining);
            com.Parameters.AddWithValue("@ispermanent", isPermanent);
            com.Parameters.AddWithValue("@isreportingmanager", isReportingManager);
            com.ExecuteNonQuery();
            if (_mode == "add")
                ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "AddUpdate", "alert('Record added.');", true);
            else
                ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "AddUpdate", "alert('Record updated.');", true);
            currentPageNumber = 1;
            BindData();
        }
    }
    protected void ddlPageSize_SelectedIndexChanged(object sender, EventArgs e)
    {
        currentPageNumber = 1;
        BindData();
    }
}
