﻿<%@ Page Title="Home Page" Language="C#" MasterPageFile="Site.master" AutoEventWireup="true"
    CodeFile="Default.aspx.cs" Inherits="_Default" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link href="Styles/TableSorter.css" rel="stylesheet" type="text/css" />
    <script src="Scripts/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="Scripts/jquery.reveal.js" type="text/javascript"></script>
    <script src="Scripts/jquery.tablesorter.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        var selectAllCheckBox = '#<%=GridViewUsers.ClientID%> input[id*="chkAllEmployee"]:checkbox';
        var selectEmployeeCheckBox = '#<%=GridViewUsers.ClientID%> input[id*="CheckBoxEmployeeID"]:checkbox';

        function CheckUncheckAll() {
            var totalCheckboxes = $(selectEmployeeCheckBox);
            var checkedCheckboxes = totalCheckboxes.filter(":checked");
            var allCheckboxesAreChecked = (totalCheckboxes.length === checkedCheckboxes.length);
            $(selectAllCheckBox).attr('checked', allCheckboxesAreChecked);
        }

        function pageLoad() {
            $(selectAllCheckBox).live('click', function () {
                $(selectEmployeeCheckBox).attr('checked', $(this).is(':checked'));
                CheckUncheckAll();
            });
            $(selectEmployeeCheckBox).live('click', CheckUncheckAll);
            CheckUncheckAll();

            $('#<%=btnAdd.ClientID%>').click(function (e) {
                e.preventDefault();
                $('#<%=hdnMode.ClientID%>').val("add");
                $('#AddUpdateUserDetails').reveal({
                    animation: 'fadeAndPop',
                    animationspeed: 300,
                    closeonbackgroundclick: false,
                    dismissmodalclass: 'close-reveal-modal'
                });
            });

            $('#<%=btnDelete.ClientID%>').bind('click', function (e) {
                var totalCheckboxes = $(selectEmployeeCheckBox);
                var checkedCheckboxes = totalCheckboxes.filter(":checked");
                var noCheckboxesAreChecked = (checkedCheckboxes.length === 0);
                if (noCheckboxesAreChecked) {
                    alert('Please select record(s) to delete.');
                    return false;
                }
                else
                    return confirm('Are you sure you want to delete the selected record(s)?');
            });
            $('#<%=btnSave.ClientID%>').bind('click', function () {
                if ($('#<%=TextBoxUserID.ClientID%>').val() == '') { alert('Enter User ID.'); return false; }
                if ($('#<%=TextBoxFirstName.ClientID%>').val() == '') { alert('Enter First Name.'); return false; }
                if ($('#<%=TextBoxLastName.ClientID%>').val() == '') { alert('Enter Last Name.'); return false; }
                if ($('#<%=TextBoxDOB.ClientID%>').val() == '') { alert('Enter D. O. B.'); return false; }
                if (!isDate($('#<%=TextBoxDOB.ClientID%>').val())) { alert('Enter valid D. O. B.'); return false; }
                if ($('#<%=TextBoxCellNumber.ClientID%>').val() == '') { alert('Enter Cell Number.'); return false; }
                if ($('#<%=TextBoxLandlineNumber.ClientID%>').val() == '') { alert('Enter Landline Number'); return false; }
                if ($('#<%=TextBoxEMailID.ClientID%>').val() == '') { alert('Enter E-Mail ID.'); return false; }
                var regexMail = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                if (!regexMail.test($('#<%=TextBoxEMailID.ClientID%>').val())) { alert('Enter valid E-Mail ID.'); return false; }
                if ($('#<%=TextBoxAddress.ClientID%>').val() == '') { alert('Enter Address.'); return false; }
                if ($('#<%=TextBoxExperience.ClientID%>').val() == '') { alert('Enter Experience.'); return false; }
                if ($('#<%=TextBoxSkills.ClientID%>').val() == '') { alert('Enter Skills.'); return false; }
                if ($('#<%=TextBoxDesignation.ClientID%>').val() == '') { alert('Enter Designation'); return false; }
                if ($('#<%=TextBoxPreviousCompany.ClientID%>').val() == '') { alert('Enter Previous Company.'); return false; }
                if ($('#<%=TextBoxDOJ.ClientID%>').val() == '') { alert('Enter D. O. J.'); return false; }
                if (!isDate($('#<%=TextBoxDOJ.ClientID%>').val())) { alert('Enter valid  D. O. J.'); return false; }
                if ($('#<%=hdnMode.ClientID%>').val() == "add")
                    if ($('#<%=FileUploadUserImage.ClientID%>').val() == '') { alert('Select an image.'); return false; }
                if ($('#<%=FileUploadUserImage.ClientID%>').val() != '') {
                    var regexfileExtension = /^(([a-zA-Z]:)|(\\{2}\w+)\$?)(\\(\w[\w].*))+(.jpg|.JPG|.jpeg|.JPEG|.gif|.GIF|.png|.PNG)$/;
                    if (!regexfileExtension.test($('#<%=FileUploadUserImage.ClientID%>').val())) { alert('Select valid image.'); return false; }
                }
                return true;
            });
            $('#<%=GridViewUsers.ClientID%>').tablesorter(
            { headers: { 0: { sorter: false }, 5: { sorter: false }, 6: { sorter: false }, 7: { sorter: false} }
            });
        }

        function isDate(txtDate) {
            var currVal = txtDate;
            if (currVal == '')
                return false;
            var rxDatePattern = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(\d{4})$/;
            var dtArray = currVal.match(rxDatePattern);
            if (dtArray == null)
                return false;
            dtMonth = dtArray[1];
            dtDay = dtArray[3];
            dtYear = dtArray[5];

            if (dtMonth < 1 || dtMonth > 12)
                return false;
            else if (dtDay < 1 || dtDay > 31)
                return false;
            else if ((dtMonth == 4 || dtMonth == 6 || dtMonth == 9 || dtMonth == 11) && dtDay == 31)
                return false;
            else if (dtMonth == 2) {
                var isleap = (dtYear % 4 == 0 && (dtYear % 100 != 0 || dtYear % 400 == 0));
                if (dtDay > 29 || (dtDay == 29 && !isleap))
                    return false;
            }
            return true;
        }
        function getDetailsToEdit(objID) {
            $('#<%=HdnID.ClientID%>').val(objID);
            $.ajax({
                url: "AjaxRequestHandler.ashx",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                data: { 'EID': objID },
                responseType: "json",
                success: OnEditRequestComplete,
                error: OnFail
            });
            return false;
        }
        function getDetails(objID) {
            $.ajax({
                url: "AjaxRequestHandler.ashx",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                data: { 'EID': objID },
                responseType: "json",
                success: OnComplete,
                error: OnFail
            });
        }
        function OnEditRequestComplete(result) {
            $('#<%=hdnMode.ClientID%>').val("edit");
            $('#AddUpdateUserDetails').reveal({
                animation: 'fadeAndPop',
                animationspeed: 300,
                closeonbackgroundclick: false,
                dismissmodalclass: 'close-reveal-modal'
            });
            $('#<%=TextBoxUserID.ClientID%>').val(result.EDCode);
            $('#<%=TextBoxFirstName.ClientID%>').val(result.EDFirstName);
            $('#<%=TextBoxLastName.ClientID%>').val(result.EDLastName);
            $('#<%=TextBoxDOB.ClientID%>').val(result.EDDOB_MMDDYYYY);
            $('#<%=TextBoxCellNumber.ClientID%>').val(result.EDCellPhoneNumber);
            $('#<%=TextBoxLandlineNumber.ClientID%>').val(result.EDLandlineNumber);
            $('#<%=TextBoxEMailID.ClientID%>').val(result.EDEmailID);
            $('#<%=TextBoxAddress.ClientID%>').val(result.EDAddress);
            $('#<%=TextBoxExperience.ClientID%>').val(result.EDExperience);
            $('#<%=TextBoxSkills.ClientID%>').val(result.EDSkills);
            $('#<%=TextBoxDesignation.ClientID%>').val(result.EDDesignation);
            $('#<%=TextBoxPreviousCompany.ClientID%>').val(result.EDPreviousCompany);
            $('#<%=TextBoxDOJ.ClientID%>').val(result.EDDOJ_MMDDYYYY);
            $('#<%=CheckBoxIsPermanent.ClientID%>').prop("checked", result.EDIsPermanent == "Yes" ? true : false);
            $('#<%=CheckBoxIsReportingManager.ClientID%>').prop("checked", result.EDIsReportingManager == "Yes" ? true : false);
        }
        function OnComplete(result) {
            $('#UserDetails').reveal({
                animation: 'fadeAndPop',
                animationspeed: 300,
                closeonbackgroundclick: false,
                dismissmodalclass: 'close-reveal-modal'
            });
            $('#userid').text(result.EDCode);
            $('#username').text(result.EDFirstName + ' ' + result.EDLastName);
            $('#userdob').text(result.EDDOB);
            $('#usercellnumber').text(result.EDCellPhoneNumber);
            $('#userlandlinenumber').text(result.EDLandlineNumber);
            $('#useremailid').text(result.EDEmailID);
            $('#useraddress').text(result.EDAddress);
            $('#userexperience').text(result.EDExperience);
            $('#userskills').text(result.EDSkills);
            $('#userdesignation').text(result.EDDesignation);
            $('#userpreviouscompany').text(result.EDPreviousCompany);
            $('#userdoj').text(result.EDDOJ);
            $('#userpermanent').text(result.EDIsPermanent);
            $('#userreportingmanager').text(result.EDIsReportingManager);
            $("#userImage").attr("src", 'UserImages/' + result.EDImagePath);
        }
        function OnFail(result) {
            alert('Request can not be completed at this moment. Please try again later.');
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <h2>
        Example for paging, sorting, adding, updating, deleting and on-demand details in
        a gridview.
    </h2>
    <asp:HiddenField ID="hdnMode" runat="server" />
    <asp:HiddenField ID="HdnID" runat="server" />
    <asp:UpdatePanel runat="server" ID="UpdatePanelMain" UpdateMode="Conditional">
        <Triggers>
            <asp:PostBackTrigger ControlID="btnSave" />
        </Triggers>
        <ContentTemplate>
            <div id="AddUpdateUserDetails" class="reveal-modal">
                <a class="close-reveal-modal">x</a>
                <table cellspacing="0" cellpadding="1" border="0" width="100%">
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            ID
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxUserID" runat="server" MaxLength="10" Width="120px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            First Name
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxFirstName" runat="server" MaxLength="50" Width="200px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Last Name
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxLastName" runat="server" MaxLength="50" Width="200px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            D. O. B.
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxDOB" runat="server" MaxLength="10" Width="120px"></asp:TextBox><span
                                class="notify">(mm/dd/yyyy)</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Cell Number
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxCellNumber" runat="server" MaxLength="12" Width="130px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Landline Number
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxLandlineNumber" runat="server" MaxLength="12" Width="130px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            E-Mail ID
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxEMailID" runat="server" MaxLength="50" Width="200px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Address
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxAddress" runat="server" MaxLength="250" Width="300px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Experience
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxExperience" runat="server" MaxLength="15" Width="150px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Skills
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxSkills" runat="server" MaxLength="50" Width="200px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Designation
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxDesignation" runat="server" MaxLength="25" Width="150px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Previous Company
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxPreviousCompany" runat="server" MaxLength="50" Width="200px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            D. O. J.
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:TextBox ID="TextBoxDOJ" runat="server" MaxLength="10" Width="120px"></asp:TextBox><span
                                class="notify">(mm/dd/yyyy)</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Permanent
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:CheckBox ID="CheckBoxIsPermanent" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Reporting Manager
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:CheckBox ID="CheckBoxIsReportingManager" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            User Image
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            <asp:FileUpload ID="FileUploadUserImage" runat="server" Width="250px" /><span class="notify">jpg|png|gif|bmp</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" colspan="2" style="width: 100%">
                            <asp:Button ID="btnSave" runat="server" Text="Save" ToolTip="Save" CssClass="appButton"
                                OnClick="btnSave_Click" />
                        </td>
                    </tr>
                </table>
            </div>
            <div id="UserDetails" class="reveal-modal">
                <a class="close-reveal-modal">x</a>
                <br />
                <table cellspacing="0" cellpadding="3" border="0" width="100%">
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            ID
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userid"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Name
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="username"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            D. O. B.
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userdob"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Cell Number
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="usercellnumber"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Landline Number
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userlandlinenumber"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            E-Mail ID
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="useremailid"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Address
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="useraddress"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Experience
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userexperience"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Skills
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userskills"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Designation
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userdesignation"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Previous Company
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userpreviouscompany"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            D. O. J.
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userdoj"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Permanent
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userpermanent"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" style="width: 30%" valign="top">
                            Reporting Manager
                        </td>
                        <td align="left" style="width: 70%" valign="top">
                            :&nbsp;<span id="userreportingmanager"></span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" style="width: 100%" valign="top" colspan="2">
                            <img id="userImage" alt="userImage" height="108px" width="108px" style="border: 1px solid #CCCCCC" />
                        </td>
                    </tr>
                </table>
            </div>
            <p>
                <asp:Button ID="btnAdd" runat="server" Text="Add" ToolTip="Add" CssClass="appButton"
                    OnClick="btnAdd_Click" />
                <asp:Button ID="btnDelete" runat="server" Text="Delete" ToolTip="Delete" CssClass="appButton"
                    OnClick="btnDelete_Click" />
            </p>
            <table cellspacing="0" cellpadding="0" width="100%" border="0" style="background-color: #4D4D4D">
                <tr style="background-color: #FFFFFF;">
                    <td align="right" style="width: 100%; padding-bottom: 10px;" colspan="2">
                        <asp:TextBox ID="txtKeyWord" runat="server" CssClass="appTextBox" MaxLength="25"></asp:TextBox>&nbsp;<asp:Button
                            ID="ButtonSearch" runat="server" Text="Search" ToolTip="Search" CssClass="appButton"
                            OnClick="ButtonSearch_Click" />
                        &nbsp;
                    </td>
                </tr>
                <tr>
                    <td align="left" colspan="2" style="width: 100%; padding-bottom: 5px; padding-top: 5px;">
                        <asp:GridView ID="GridViewUsers" runat="server" AllowPaging="true" PagerSettings-Visible="false"
                            Width="100%" AutoGenerateColumns="false" OnRowCommand="GridViewUsers_RowCommand"
                            ShowHeaderWhenEmpty="False" EmptyDataText="No records Found" OnRowDataBound="GridViewUsers_RowDataBound"
                            CssClass="tablesorter" DataKeyNames="ED_ID">
                            <HeaderStyle Font-Names="Verdana" Font-Size="6px" ForeColor="Black" />
                            <RowStyle Font-Names="Verdana" />
                            <AlternatingRowStyle Font-Names="Verdana" />
                            <Columns>
                                <asp:TemplateField HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left"
                                    HeaderStyle-CssClass="header">
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="chkAllEmployee" runat="server" Text="Select All" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <asp:CheckBox ID="CheckBoxEmployeeID" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Employee ID" HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left">
                                    <ItemTemplate>
                                        <asp:Label ID="linkDetails" runat="server" Text='<%# Eval("ED_Code") %>' CssClass="userDetails"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Employee Name" HeaderStyle-HorizontalAlign="Left"
                                    ItemStyle-HorizontalAlign="Left">
                                    <ItemTemplate>
                                        <asp:Label ID="lblEmployeeName" runat="server" Text='<%# Eval("ED_FirstName")+ " " +Eval("ED_LastName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Designation" HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left">
                                    <ItemTemplate>
                                        <asp:Label ID="lblEmployeeDesignation" runat="server" Text='<%# Eval("ED_Designation") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Date of Joining" HeaderStyle-HorizontalAlign="Left"
                                    ItemStyle-HorizontalAlign="Left">
                                    <ItemTemplate>
                                        <asp:Label ID="lblEmployeeDateOfJoining" runat="server" Text='<%# Eval("ED_DOJ","{0:dd/MM/yyyy}") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Permanent" HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left"
                                    HeaderStyle-CssClass="header">
                                    <ItemTemplate>
                                        <asp:Literal ID="ltrlImagePermanent" runat="server" Text='<%# SetImage(Eval("ED_IsPermanent").ToString()) %>'></asp:Literal>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Reporting Manager" HeaderStyle-HorizontalAlign="Left"
                                    ItemStyle-HorizontalAlign="Left" HeaderStyle-CssClass="header">
                                    <ItemTemplate>
                                        <asp:Literal ID="ltrlImageReportingManager" runat="server" Text='<%# SetImage(Eval("ED_IsReportingManager").ToString()) %>'></asp:Literal>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Action" HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left"
                                    HeaderStyle-CssClass="header">
                                    <ItemTemplate>
                                        <asp:Button ID="btnEditRow" Text="Edit" runat="server" CssClass="editButton" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </td>
                </tr>
                <tr style="background-color: #4D4D4D; font-family: Verdana; color: #FFFFFF">
                    <td align="left" style="width: 50%" valign="top">
                        Page Size:&nbsp;<asp:DropDownList ID="ddlPageSize" runat="server" AutoPostBack="true"
                            OnSelectedIndexChanged="ddlPageSize_SelectedIndexChanged" CssClass="ddlItem">
                            <asp:ListItem Text="10" Value="10"></asp:ListItem>
                            <asp:ListItem Text="20" Value="20"></asp:ListItem>
                            <asp:ListItem Text="30" Value="30"></asp:ListItem>
                            <asp:ListItem Text="40" Value="40"></asp:ListItem>
                            <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        </asp:DropDownList>
                        &nbsp; Page&nbsp;
                        <asp:Label ID="lblCurrentPage" runat="server" CssClass="labelMessage"></asp:Label>&nbsp;of&nbsp;<asp:Label
                            ID="lblTotalPages" runat="server" CssClass="labelMessage"></asp:Label>
                    </td>
                    <td align="right" style="width: 50%">
                        <asp:Button ID="Btn_Previous" runat="server" Text="Previous" OnClick="Btn_Previous_Click" />&nbsp;
                        <asp:Button ID="Btn_Next" runat="server" Text="Next" OnClick="Btn_Next_Click" />
                    </td>
                </tr>
            </table>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
