﻿<%@ WebHandler Language="C#" Class="AjaxRequestHandler" %>

using System;
using System.Web;
using System.Web.Script.Serialization;
using System.Data;
using System.Data.SqlClient;

public class AjaxRequestHandler : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        var userDetails = GetUserDetails(Convert.ToInt32(context.Request["EID"].Trim()));
        JavaScriptSerializer javaScriptSerializer = new JavaScriptSerializer();
        string serializedUserDetails = javaScriptSerializer.Serialize(userDetails);
        context.Response.ContentType = "text/html";
        context.Response.Write(serializedUserDetails);
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    private User GetUserDetails(int Id)
    {
        var user = new User();
        using (SqlConnection con = new SqlConnection(System.Web.Configuration.WebConfigurationManager.ConnectionStrings["SqlConnection"].ConnectionString))
        {
            con.Open();
            DataTable dtFiles = new DataTable();
            SqlCommand com = new SqlCommand("SP_GetCompleteUserDetails", con);
            com.CommandType = CommandType.StoredProcedure;
            com.Parameters.AddWithValue("@userid", Id);
            SqlDataReader dr = com.ExecuteReader();
            if (dr.HasRows)
            {
                dr.Read();
                user.EDCode = dr["ED_Code"].ToString().Trim();
                user.EDFirstName = dr["ED_FirstName"].ToString().Trim();
                user.EDLastName = dr["ED_LastName"].ToString().Trim();
                user.EDDOB = dr["ED_DOB"].ToString().Trim();
                user.EDDOB_MMDDYYYY = Convert.ToDateTime(dr["ED_DOB"]).ToString("MM/dd/yyyy");
                user.EDCellPhoneNumber = dr["ED_CellPhoneNumber"].ToString().Trim();
                user.EDLandlineNumber = dr["ED_LandlineNumber"].ToString().Trim();
                user.EDEmailID = dr["ED_EmailID"].ToString().Trim();
                user.EDAddress = dr["ED_Address"].ToString().Trim();
                user.EDImagePath = dr["ED_ImagePath"].ToString().Trim();
                user.EDExperience = dr["ED_Experience"].ToString().Trim();
                user.EDSkills = dr["ED_Skills"].ToString().Trim();
                user.EDDesignation = dr["ED_Designation"].ToString().Trim();
                user.EDPreviousCompany = dr["ED_PreviousCompany"].ToString().Trim();
                user.EDDOJ = dr["ED_DOJ"].ToString().Trim();
                user.EDDOJ_MMDDYYYY = Convert.ToDateTime(dr["ED_DOJ"]).ToString("MM/dd/yyyy");
                user.EDIsPermanent = dr["ED_IsPermanent"].ToString().Trim();
                user.EDIsReportingManager = dr["ED_IsReportingManager"].ToString().Trim();
            }
        }
        return user;
    }

}
public class User
{
    public string EDCode { get; set; }
    public string EDFirstName { get; set; }
    public string EDLastName { get; set; }
    public string EDDOB { get; set; }
    public string EDCellPhoneNumber { get; set; }
    public string EDLandlineNumber { get; set; }
    public string EDEmailID { get; set; }
    public string EDAddress { get; set; }
    public string EDImagePath { get; set; }
    public string EDExperience { get; set; }
    public string EDSkills { get; set; }
    public string EDDesignation { get; set; }
    public string EDPreviousCompany { get; set; }
    public string EDDOJ { get; set; }
    public string EDIsPermanent { get; set; }
    public string EDIsReportingManager { get; set; }
    public string EDDOB_MMDDYYYY { get; set; }
    public string EDDOJ_MMDDYYYY { get; set; }
}