<?php
/**
 * @author Michele Andreoli <michi.andreoli@gmail.com>
 * @name SmartGAPI.class.php
 * @version 0.4 updated 01-05-2011
 * @license http://opensource.org/licenses/gpl-license-php GNU Public License
 * @package SmartGAPI
 */

    /**
     * Class for create quickly your statistics box from Google Analytics
     */
    class SmartGAPI {
        private $dir_gapi = null;
        private $dir_req = null;
        private $id = null;
        private $message = "Wait while loading statistics...";
        private $div_id = "statsbox";
        private $starting_date = null;
        private $ending_date = null;
        private $timezone = null;

        /**
         * Constructor for GAPI
         * @param $dir_gapi
         * @param $dir_req
         * @param $id
         */
        public function __construct($dir_gapi, $dir_req, $id) {
            $this->dir_gapi = $dir_gapi;
            $this->dir_req = $dir_req;
            $this->id = $id;
        }

        /**
         * Setter for gapi.class.php directory
         * @param $dir_gapi
         */
        public function setDir_gapi($dir) {
            $this->dir_gapi = $dir;
        }

        /**
         * Setter for request.php directory
         * @param $dir_req
         */
        public function setDir_req($dir) {
            $this->dir_req = $dir;
        }

        /**
         * Setter for id parameter
         * @param $id
         */
        public function setId($id) {
            $this->id = $id;
        }

        /**
         * Setter for loading message
         * @param $message = Wait while loading statistics...
         */
        public function setMessage($message) {
            $this->message = $message;
        }

        /**
         * Setter for id div of message content
         * @param $id
         */
        public function setDiv_id($div) {
            $this->div_id = $div;
        }

        /**
         * Set the starting date of your stats (the ending date is the current day),
         * if setStarting_date is not setted the stats refers to the current month
         * @param $starting_date 'yyyy-mm-dd'
         * @param $timezone 'Europe/Rome' optional
         * @param $ending_date 'yyyy-mm-dd' optional
         */
        public function setStarting_date($starting_date, $timezone = null, $ending_date = null) {
            $this->starting_date = $starting_date;
            $this->ending_date = $ending_date;
            $this->timezone = $timezone;

            if ($this->starting_date == null)
                $this->ending_date = null;
            else {
                if ($this->ending_date == null) {
                    date_default_timezone_set($this->timezone);
                    $this->ending_date = date('Y-m-d');
                }
            }
        }

        /**
         * Show the stats box
         * @param $mode = fade
         */
        public function showGapiBox($mode=null) {
            $fade = "";

            if ($mode == "fade") {
                $fade = ".hide().fadeIn('slow')";
            }

            $string = "<script type=\"text/javascript\">";
            $string.= "$(document).ready(function() {";
            $string.= "$.ajax ({";
            $string.= "type: 'POST',";
            $string.= "url: '".$this->dir_req."',";
            $string.= "data: {'dir':'".$this->dir_gapi."', 'id':'".$this->id."', 'starting_date':'".$this->starting_date."', 'ending_date':'".$this->ending_date."', 'timezone':'".$this->timezone."'},";
            $string.= "dataType: 'text',";
            $string.= "success: function (ret) {";
            $string.= "$('div#".$this->div_id."').html(ret)".$fade."; } }); });";
            $string.= "</script>";
            $string .= "<div id=\"".$this->div_id."\">".$this->message."</div>";

            echo $string;
        }
    }
?>