﻿using ExportDemo.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using iTextSharp;
using iTextSharp.text.pdf;
using iTextSharp.text;
using System.IO;

namespace ExportDemo.Controllers
{
    public class HomeController : Controller
    {
        private readonly IList<CustomerViewModel> customerList;

        public HomeController()
        {
            customerList =new List<CustomerViewModel>() {
                new CustomerViewModel{CustomerID=100,CustomerName="Sundar",Location="Chennai",PrimaryBusiness="Teacing"},
                new CustomerViewModel{CustomerID=101,CustomerName="Sudhagar",Location="Chennai",PrimaryBusiness="Software"},
                new CustomerViewModel{CustomerID=102,CustomerName="Thivagar",Location="China",PrimaryBusiness="SAP"},
            };
        }

        [HttpGet]
        public JsonResult GetCustomerDetails()
        {
            var result = new
            {
                total = 1,
                page = 1,
                records = customerList.Count(),
                rows =(
                    customerList.Select(e=>
                        new {id=e.CustomerID,cell=new string[]{
                            e.CustomerID.ToString(),e.CustomerName,e.Location,e.PrimaryBusiness
                        }})
                ).ToArray()
            };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        public ActionResult Index(bool? pdf)
        {
           if (!pdf.HasValue)
           {
               return View(customerList);
           }
           else
           {
               string filePath = Server.MapPath("Content") + "Sample.pdf";
               ExportPDF(customerList, new string[] { "CustomerID", "CustomerName", "Location", "PrimaryBusiness" }, filePath);

               return File(filePath, "application/pdf","list.pdf"); 
           }
        }

        private static void ExportPDF<TSource>(IList<TSource> customerList,string[] columns, string filePath)
        {
            Font headerFont = FontFactory.GetFont("Verdana", 10, Color.WHITE);
            Font rowfont = FontFactory.GetFont("Verdana", 10, Color.BLUE);
            Document document = new Document(PageSize.A4);

            PdfWriter writer = PdfWriter.GetInstance(document, new FileStream(filePath, FileMode.OpenOrCreate));
            document.Open();
            PdfPTable table = new PdfPTable(columns.Length);
            foreach (var column in columns)
            {
                PdfPCell cell = new PdfPCell(new Phrase(column, headerFont));
                cell.BackgroundColor = Color.BLACK;
                table.AddCell(cell);
            }
            
            foreach (var item in customerList)
            {
                foreach (var column in columns)
                {
                    string value = item.GetType().GetProperty(column).GetValue(item).ToString();
                    PdfPCell cell5 = new PdfPCell(new Phrase(value, rowfont));
                    table.AddCell(cell5);
                }           
            }

            document.Add(table);
            document.Close();
        }
    }
}
