﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using System.Text.RegularExpressions;

namespace SQLInjection
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            //vulnerable to SQL injection 

            //UsingQuery();

            //prevent sqlinjection

           // UsingRegex();

            //UsingParameterizedQuery();

            UsingStoredProcedure();
           
        }

        private void UsingQuery()
        {
            string connectionString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
            //problem is here .we are using inline query which is not a sql query its basically a string whic passed as sql statement .
            //nd we cocatenate here,so its become very easy to concatenate anything 
            string query = string.Format(@"select Username ,Age,Department from [User] where Username like '%{0}%'", TextBox1.Text);

            using (SqlConnection con = new SqlConnection(connectionString))
            {
                //
                // Open the SqlConnection.
                //
                con.Open();
                //
                // The following code uses an SqlCommand based on the SqlConnection.
                //
                using (SqlDataAdapter da = new SqlDataAdapter())
                {
                    using (SqlCommand command = new SqlCommand(query, con))
                    {
                        DataSet ds = new DataSet();
                        da.SelectCommand = command;
                        da.Fill(ds, "test");
                        GridView1.DataSource = ds;
                        GridView1.DataBind();
                    }
                }

            }
        }



        private void UsingRegex()
        {

                  string connectionString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
            //problem is here .we are using inline query which is not a sql query its basically a string whic passed as sql statement .
            //nd we cocatenate here,so its become very easy to concatenate anything 
            


            //Validate the user input
            string userinput = TextBox1.Text;
            //we will only accept the alphabets and numbers , rest will be replaced by blank
            userinput = Regex.Replace(userinput, "[^A-Za-z0-9$]", "");

            string query = string.Format(@"select Username ,Age,Department from [User] where Username like '%{0}%'", userinput);
            using (SqlConnection con = new SqlConnection(connectionString))
            {
                //
                // Open the SqlConnection.
                //
                con.Open();
                //
                // The following code uses an SqlCommand based on the SqlConnection.
                //
                using (SqlDataAdapter da = new SqlDataAdapter())
                {
                    using (SqlCommand command = new SqlCommand(query, con))
                    {
                        DataSet ds = new DataSet();
                        da.SelectCommand = command;
                        da.Fill(ds, "test");
                        GridView1.DataSource = ds;
                        GridView1.DataBind();
                    }
                }

            }
        }

        private void UsingParameterizedQuery()
        {
            string connectionString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
         //add the parameter 
            string query = string.Format(@"select Username ,Age,Department from [User] where Username like '%+@Username+%'", TextBox1.Text);

            using (SqlConnection con = new SqlConnection(connectionString))
            {
                //
                // Open the SqlConnection.
                //
                con.Open();
                //
                // The following code uses an SqlCommand based on the SqlConnection.
                //
                using (SqlDataAdapter da = new SqlDataAdapter())
                {
                    using (SqlCommand command = new SqlCommand(query, con))
                    {
                        //pass the parameter
                        command.Parameters.Add(new SqlParameter("@Username",TextBox1.Text)) ;
                        DataSet ds = new DataSet();
                        da.SelectCommand = command;
                        da.Fill(ds, "test");
                        GridView1.DataSource = ds;
                        GridView1.DataBind();
                    }
                }

            }
        }
        private void UsingStoredProcedure()
        {

            string connectionString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
            //add the stored procedure name 
            string query = "dbo.GetUsername";

            using (SqlConnection con = new SqlConnection(connectionString))
            {
                //
                // Open the SqlConnection.
                //
                con.Open();
                //
                // The following code uses an SqlCommand based on the SqlConnection.
                //
                using (SqlDataAdapter da = new SqlDataAdapter())
                {
                    using (SqlCommand command = new SqlCommand(query, con))
                    {
                        //pass the parameter
                        command.Parameters.Add(new SqlParameter("@param1", TextBox1.Text));
                        command.CommandType = CommandType.StoredProcedure;
                        DataSet ds = new DataSet();
                        da.SelectCommand = command;
                        da.Fill(ds, "test");
                        GridView1.DataSource = ds;
                        GridView1.DataBind();
                    }
                }
            }
        }
    }
}