﻿<%@ Page Language="C#" Inherits="Demo.Classes.BaseErrorPage" MasterPageFile="~/Default.master" Theme="Omega" ValidateRequest="false" %>

<asp:Content ID="HtmlHeadContent" runat="server" ContentPlaceHolderID="HeadContent">
    
</asp:Content>

<asp:Content ID="HtmlTitleContent" runat="server" ContentPlaceHolderID="TitleContent">
    <div runat="server" id="BannerTitle" class="title">Page Not Found</div>
    <div class="blurb">Oops... an unexpected event has just occurred</div>
</asp:Content>

<asp:Content ID="HtmlBodyContent" runat="server" ContentPlaceHolderID="BodyContent">
    
    <asp:HiddenField runat="server" ID="StatusCode" Value="404" />
    <asp:HiddenField runat="server" ID="ReportTitle" />
    <asp:HiddenField runat="server" ID="ReportBody" />

    <h1><asp:Literal runat="server" ID="CrashReportTitle" /></h1>

    <p>
        <asp:Literal runat="server" ID="BrokenUrl" />
    </p>
	
    <p>
    Sorry, but the page you were looking for can’t be found. See below for what you can do about that.
    </p>

    <h2>
    Next Steps
    </h2>

    <demo:NextStepsLinkList runat="server" ID="NextSteps" />

    <asp:Panel runat="server" ID="ErrorReportPanel">
	
    <h2>
    Quick Error Report
    </h2>

    <p>
    You can quickly report this missing page by clicking the button below. After
    you click this button the page will reload and send us an email message with 
    the relevant details.
    </p>

    <asp:LinkButton runat="server" ID="SubmitQuickErrorReportButton" Text="Submit Quick Error Report" CssClass="button blue" />
            
    <asp:Literal runat="server" ID="CrashReportBody" />

    </asp:Panel>
    
</asp:Content>