﻿using System;
using System.Configuration;

namespace Demo.Classes
{
    public static class AppSettingsHelper
    {
        #region Get String value

        public static String GetValue(String key)
        {
            return GetValue(key, true, null);
        }

        public static String GetValue(String key, Boolean required)
        {
            return GetValue(key, required, null);
        }

        public static String GetValue(String key, Boolean required, String defaultValue)
        {
            String value = ConfigurationManager.AppSettings[key];

            if (String.IsNullOrEmpty(value))
            {
                if (required && defaultValue == null)
                    throw new DemoException("Application setting not found: " + key);

                return defaultValue;
            }

            return value;
        }

        #endregion

        #region Get Decimal value

        public static Decimal GetValueAsDecimal(String key)
        {
            return GetValueAsDecimal(key, true, null).Value;
        }

        public static Decimal GetValueAsDecimal(String key, Decimal defaultValue)
        {
            return GetValueAsDecimal(key, true, defaultValue).Value;
        }

        public static Decimal? GetValueAsNullableDecimal(String key)
        {
            return GetValueAsDecimal(key, false, null);
        }

        public static Decimal? GetValueAsDecimal(String key, Boolean required, Decimal? defaultValue)
        {
            String stringValue = GetValue(key, required && defaultValue == null, null);

            if (String.IsNullOrEmpty(stringValue))
                return defaultValue;

            Decimal value;

            if (Decimal.TryParse(stringValue, out value))
                return value;

            throw new DemoException("Application setting is not valid Decimal value: " + key);
        }

        #endregion

        #region Get Int32 value

        public static Int32 GetValueAsInt32(String key)
        {
            return GetValueAsInt32(key, true, null).Value;
        }

        public static Int32 GetValueAsInt32(String key, Int32 defaultValue)
        {
            return GetValueAsInt32(key, true, defaultValue).Value;
        }

        public static Int32? GetValueAsNullableInt32(String key)
        {
            return GetValueAsInt32(key, false, null);
        }

        public static Int32? GetValueAsInt32(String key, Boolean required, Int32? defaultValue)
        {
            String stringValue = GetValue(key, required && defaultValue == null, null);

            if (String.IsNullOrEmpty(stringValue))
                return defaultValue;

            Int32 value;

            if (Int32.TryParse(stringValue, out value))
                return value;

            throw new DemoException("Application setting is not valid Int32 value: " + key);
        }

        #endregion

        #region Get Boolean value

        public static Boolean GetValueAsBoolean(String key)
        {
            return GetValueAsBoolean(key, true, null).Value;
        }

        public static Boolean GetValueAsBoolean(String key, Boolean defaultValue)
        {
            return GetValueAsBoolean(key, false, defaultValue).Value;
        }

        public static Boolean? GetValueAsNullableBoolean(String key)
        {
            return GetValueAsBoolean(key, false, null);
        }

        public static Boolean? GetValueAsBoolean(String key, Boolean required, Boolean? defaultValue)
        {
            String stringValue = GetValue(key, required && defaultValue == null, null);

            if (String.IsNullOrEmpty(stringValue))
                return defaultValue;

            Boolean value;

            if (Boolean.TryParse(stringValue, out value))
                return value;

            throw new DemoException("Application setting is not valid Boolean value: " + key);
        }

        #endregion

        #region Get DateTime value

        public static DateTime GetValueAsDateTime(String key)
        {
            return GetValueAsDateTime(key, true, null).Value;
        }

        public static DateTime GetValueAsDateTime(String key, DateTime defaultValue)
        {
            return GetValueAsDateTime(key, true, defaultValue).Value;
        }

        public static DateTime? GetValueAsNullableDateTime(String key)
        {
            return GetValueAsDateTime(key, false, null);
        }

        public static DateTime? GetValueAsDateTime(String key, Boolean required, DateTime? defaultValue)
        {
            String stringValue = GetValue(key, required && defaultValue == null, null);

            if (String.IsNullOrEmpty(stringValue))
                return defaultValue;

            DateTime value;

            if (DateTime.TryParse(stringValue, out value))
                return value;

            throw new DemoException("Application setting is not valid DateTime value: " + key);
        }

        #endregion
    }
}