<?
/**
 * @name Graphical Navigation Bar
 * @license GPL 
 * @copyright http://www.wondercoder.com/ RosePendarSystem Co
 * @link http://www.wondercoder.com/ email:MehdiSafavy@yahoo.com
 * @package BOOK24.ir
 * @access Public
 */
class Navigator {
	var $PerPageRows;
	var $DistancePages;
	/** 
	* @name  Navigator Footer Maker 
	* @desc  Navigator Footer Maker Like Google Graphical Nbar
	* @param $modulename(optional) - $offset(Sql Limit Value) 
	* @param $num_rows(Number of Returned Records in Sql) - $extra(optional other $get values)
	*/
	function MakeFooter($modulename, $offset, $num_rows,$extra="") {
		
		if (!is_numeric($this->PerPageRows) and !is_numeric($this->DistancePages)){
			echo "Please Define \$this->PerPageRows and \$this->DistancePages First!";
		}
		$footer  = "<BR>\n";
		$footer .= "<div  align='center'>";
	
		// Get total pages
		$num_pages = intval($num_rows / $this->PerPageRows);
		if ($num_rows % $this->PerPageRows)
		$num_pages++;
		$page_num=($offset/$this->PerPageRows)+1;
	
		$from = $offset + 1;
		$to = $offset + $this->PerPageRows;
		if ($to > $num_rows)
		$to = $num_rows;
	
			
		//print the page number
		if ($num_pages == 1)
		$footer .= "Page  
		<B>1</B> From  <B>1</B><br>";
		else
		$footer .= "Page <B>". $page_num ."</B> Of <B>" .$num_pages. "</B><br>";	
		
	
		//print the current record
		$footer .= "<u>";
		if ($num_rows == 1)
		$footer .= "Record <B>1</B> From <B>1</B>";
		elseif ($from == $to)
		$footer .= "Record <B>". $from ."</B> From <B>" .$num_rows. "</B>";
		else
		$footer .= "Record <B>". $from ."</B> To <B>" .$to. "</B> Of <B>" .$num_rows. "</B>";
		$footer .="</u>";
		$footer .= "<br><br>";
	
		//print the previous page link
		
	
		//print links to the pages in range
		if ($num_pages != 1 and $num_pages != 0) {
	
			$start_page=$page_num-intval($this->DistancePages/2);
			if($start_page<=0) $start_page=1;
	
			$end_page=$page_num+intval($this->DistancePages/2);
			if($end_page>$num_pages) { $end_page=$num_pages; }
			$footer.="<table border='0' dir='ltr'>
					 <tr>
					  <td>
					   ";
						if ($offset >= $this->PerPageRows) {
							$prevoffset=$offset-$this->PerPageRows;
							$footer .= "<A HREF='";
							$footer .= "?page=$modulename&offset=$prevoffset$extra'";
							$footer .= "> <img border='0' src='arrow-l.png'> </A>";
						}
						else
						$footer .= "&nbsp;";
	
					$footer .="
					  
					  </td>
					  <td valign=top>
					    <img src='bk.png'>
					  </td>";
						for ($i=$start_page;$i<=$end_page;$i++) {
							if (($offset < $i*$this->PerPageRows) && ($offset >= ($i-1)*$this->PerPageRows)) {
								$footer .= "<td align='center' style='font-size:15'><span style='color:red'><img src='bk2.png'><br><B>" . $i . "</B></span></td>";
							}
							else {
								$pagenumber = $i;
								$newoffset = $this->PerPageRows * ($i-1);
								$footer .= "<td align='center' style='font-size:14'><A HREF='";
								$footer .= "?page=$modulename&offset=$newoffset$extra'";
								$footer .= "  style='color:Black'><img src='bk1.png' border='0'><br>  $pagenumber</A></td>";
							}
						}
			 			$footer.="
					   <td valign=top>
					    <img src='k24a.png'>
					   </td>
					   <td>";
			 			
			 			//print the next page link
			 			if (($offset+$this->PerPageRows < $num_rows) && $num_pages != 1) {
			 				$newoffset = $offset + $this->PerPageRows;
			 				$footer .= "<A HREF='";
			 				$footer .= "?page=$modulename&offset=$newoffset$extra'";
			 				$footer .=  " ><img border='0' src='arrow-r.png'></A>\n";
			 			}
			 			else
			 			$footer .= "&nbsp;";
	
					 $footer.="  
					   </td>
					  </tr>
					</table>";
		}
	
		
	
		$footer .= "<BR>";
	
				
		// print the first page button
	    
		if ($offset!=0) {
			$newoffset=0;
			$footer .= "<A HREF='?page=$modulename&offset=$newoffset$extra'";
			$footer .= "  style='color:#000'>First Page  &lt; &lt; &lt;   </A>&nbsp;";
		}
		$footer .= "&nbsp;&nbsp;&nbsp;&nbsp;";
		// print the last page button
		if ($offset+$this->PerPageRows<$num_rows) {
			$newoffset= ($num_pages - 1) * $this->PerPageRows;
			$footer .= "<A HREF='?page=$modulename&offset=$newoffset$extra''";
			$footer .= "  style='color:#000'>  &gt; &gt; &gt; Last Page </A>&nbsp;";
		}
		
		$footer .= "</div>";
	
		echo $footer;
	}

}

