﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SolutionArch.BusinessObject;
using SolutionArch.Collection.Entity;
using System.Collections;
using System.Xml.Linq;
using System.Reflection;

namespace EntityCollection
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
                      
            if (!Page.IsPostBack)
            {
                bindGrid(grdUser, PopulateUsers());

                ddlFindProperty.DataSource = PopulateFindProperty(new UserBO());
                ddlFindProperty.DataBind();

                ddlSortProperty.DataSource = PopulateFindProperty(new UserBO());
                ddlSortProperty.DataBind();

            }
        }
        /// <summary>
        /// Fetch list of property associate with input parameter
        /// </summary>
        /// <param name="obj">Business Object - UserBO etc</param>
        /// <returns>Collection with list of property</returns>
        private List<string> PopulateFindProperty(Object obj)
        {
            List<string>    objLst  = new List<string>();
            Type            typObj  = obj.GetType(); //Reflection - Class details, like name,property,method
            PropertyInfo[]  piObjs  = typObj.GetProperties(); // List of object properties 
            foreach (PropertyInfo piObj in piObjs)// Loop through each property
                objLst.Add(piObj.Name);
            return objLst;
        }

        /// <summary>
        /// Fetch list of record from datasource, Here we are using XML file as a datasource
        /// I real life it sjould be replaced with database driven record
        /// </summary>
        /// <returns>Collection with list of record</returns>
        private EntityCollection<UserBO> PopulateUsers()
        {
            string      strFilePath     =   Server.MapPath("App_Data\\DummyData.xml");
            XDocument   xmlDoc          =   XDocument.Load(strFilePath);
            
            //Linq to XML
            var         objCustomers       = from customer in xmlDoc.Descendants("Customer")
                                                select new
                                                {
                                                    Name    = customer.Element("Name").Value,
                                                    Email   = customer.Element("Email").Value,
                                                };

            UserBO objUser = null;

            EntityCollection<UserBO> objUserCollection = new EntityCollection<UserBO>();

            foreach (var objCustomer in objCustomers)
            {
                objUser         = new UserBO();
                objUser.Name    = objCustomer.Name;
                objUser.Email   = objCustomer.Email;
                objUserCollection.Add(objUser); //Populating the collection
            }
            return objUserCollection;
        }

        /// <summary>
        /// Bind grid with datasource
        /// </summary>
        /// <typeparam name="T">Generic Datasource</typeparam>
        /// <param name="grdGrid">Grid View</param>
        /// <param name="objCollection">datasource</param>
        private void bindGrid<T>(GridView grdGrid , EntityCollection<T> objCollection)
        {
            grdGrid.DataSource = objCollection;
            grdGrid.DataBind();
        }
        
        protected void btnFind_Click(object sender, EventArgs e)
        {
            EntityCollection<UserBO>    userCollection      = PopulateUsers();
            string                      strFindExpression   = ddlFindProperty.Text + "=" + txtFindVal.Text.Trim();

            userCollection = userCollection.FindByExpression(strFindExpression);
            bindGrid(grdFilterUser, userCollection);
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            EntityCollection<UserBO>    userCollection      = PopulateUsers();
            string                      strFindExpression   = ddlFindProperty.Text + "=" + txtFindVal.Text.Trim();

            userCollection = userCollection.DeleteByExpression(strFindExpression);
            bindGrid(grdFilterUser, userCollection);
        }

        protected void cmdSort_Click(object sender, EventArgs e)
        {
            EntityCollection<UserBO>    userCollection      = PopulateUsers();
            string                      strFindExpression   = ddlSortProperty.Text;

            if (ddlSortOption.SelectedItem.Text.Equals("Dsc")) strFindExpression = strFindExpression + " desc";

            userCollection = userCollection.SortByExpression(strFindExpression); // Default sort - ASC
            bindGrid(grdFilterUser, userCollection);
        }
    }
}
