﻿//****************************************************************************
// Module           :   Default.aspx.cs
// Description      :   YouTube API for ASP.NET: code behind
// Developer        :   Alexander Bell (Infosoft International Inc)
// DateCreated      :   09/10/2009
// LastModified     :   09/12/2009
//****************************************************************************
// DISCLAIMER: This Application is provide on AS IS basis without any warranty
//****************************************************************************

//****************************************************************************
// TERMS OF USE     :   ALL YouTube CONTENT IS SHOWN AS DEMO SAMPLE ONLY
//                  :   You can use it at your sole risk
//****************************************************************************

using System;

public partial class _Default : System.Web.UI.Page 
{
    // player width
    private int _W = 640;

    // player height
    private int _H = 480;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            #region Start mode customization via Web Query String
            int idx = 0;
            int auto = 0;
            string qry = "";

            // Autostart
            try {
                qry = "auto"; 
                qry = (Request.QueryString[qry] == null) ? "" : Request.QueryString[qry];
                if (qry != "") { auto = int.Parse(qry); }
            } catch { }

            // Item index
            try {
                qry = "item"; 
                qry = (Request.QueryString[qry] == null) ? "" : Request.QueryString[qry];
                if (qry != "") { idx = int.Parse(qry); }
            } catch { }
            #endregion

            // get value from the list for selected index
            cmbPlaylist.SelectedIndex = idx;

            // generate script on page load
            Literal1.Text = YouTubeScript.Get(cmbPlaylist.SelectedValue, auto, _W, _H);
        }
        else
        {
            // generate script on page postback
            Literal1.Text = YouTubeScript.Get(cmbPlaylist.SelectedValue, 0, _W, _H);
        }
    }
}
