﻿/// <reference path="jquery-1.7.1-vsdoc.js" />
/// <reference path="jquery-ui-1.8.20.js" />
/// <reference path="jquery.jqGrid.src.js" />

var lastSelectedRow;
var before_edit_value;
var after_edit_value;

$(document).ready(function () {
    $('#_siteDocumentGrid').jqGrid({
        caption: paramFromView.Caption,
        colNames: ['ID', paramFromView.FileFullName, paramFromView.Name, paramFromView.Culture, paramFromView.IsNotPublic, paramFromView.IsForAgreement, paramFromView.Date, paramFromView.Actions],
        colModel: [
                    { name: 'ID', width: 1, hidden: true, key: true },
                    { name: 'FileFullName', index: 'FileFullName', width: 200 },
                    { name: 'Name', index: 'Name', width: 110, editable: true, editoptions: { readonly: false, size: 50 }, cellEdit: true },
                    { name: 'Culture', index: 'Culture', width: 90, resizable: true, align: "center" },
                    { name: 'IsNotPublic', index: 'IsNotPublic', width: 100, align: "center" },
                    { name: 'IsForAgreement', index: 'IsForAgreement', width: 100, align: "center" },
                    { name: 'Date', index: 'Date', width: 125, align: "center" },
                    { name: 'Actions', index: 'ID', width: 65, align: "center" }
                  ],
        hidegrid: false,
        sortname: 'ID',
        altRows: false,
        rowNum: 20,
        rowList: [10, 20, 50, 100],
        sortorder: "desc",
        width: paramFromView.Width,
        height: paramFromView.Height,
        datatype: 'json',
        caption: paramFromView.Caption,
        viewrecords: true,
        mtype: 'GET',
        jsonReader: {
            root: "rows",
            page: "page",
            total: "total",
            records: "records",
            repeatitems: false,
            userdata: "userdata"
        },

        onSelectRow: function (rowid) {

            $("#_siteDocumentGrid").editRow(rowid, true);
            if (rowid && rowid !== lastSelectedRow) {
                /*
                * Determine if the value was changed, if not there is no need to save to server.
                */

                if (typeof (lastSelectedRow) != 'undefined') {
                    after_edit_value = $('#_siteDocumentGrid td input#' + lastSelectedRow + '_Name').val();
                }

                if (before_edit_value != after_edit_value) {
                    $("#_siteDocumentGrid").jqGrid('saveRow', lastSelectedRow);
                }
                else {
                    /*
                    * Restore the row.
                    */
                    $("#_siteDocumentGrid").jqGrid('restoreRow', lastSelectedRow);
                    $("#_siteDocumentGrid").jqGrid('saveRow', lastSelectedRow);

                }
                before_edit_value = $('#_siteDocumentGrid td input#' + rowid + '_Name').val();
            }
            lastSelectedRow = rowid;


        },
        editurl: paramFromView.EditSiteDocumentUrl,
        url: paramFromView.Url
    })
    window.onbeforeunload = checkForChanges;
});


function checkForChanges() {
    if ($('#_siteDocumentGrid tr#' + lastSelectedRow).attr("editable") == "1") {
        var lastvalue = $('#_siteDocumentGrid td input#' + lastSelectedRow + '_Name').val();
        if (typeof (lastvalue) != 'undefined') {
            if (before_edit_value != lastvalue) {
                return 'You have unsaved changes that will be discarded.';
            }
        }
    }

}


