﻿using System.Linq;
using System.Web.Mvc;
using System.Web;
using System.Data;
using System.IO;
using System.Collections;
using System.Collections.Generic;
//
using MvcBasic.Logic;
using MvcBasicSite.Models.Helpers;

namespace MvcBasicSite.Controllers
{
    /// <summary>
    /// Defines the site settings controller.
    /// </summary>
    public class SiteSettingController : BaseController
    {
        /// <summary>
        /// Gets the site title.
        /// </summary>
        public static string SiteTitle
        {
            get
            {
                using (MvcBasicSiteEntities dataContext = new MvcBasicSiteEntities())
                {
                    SiteSetting siteSetting = dataContext.SiteSettings.First();
                    //
                    return (string.IsNullOrEmpty(siteSetting.SiteTitle) ? Resources.Resource.WebAppTitle : siteSetting.SiteTitle);
                }
            }
        }
        /// <summary>
        /// Gets "has header image" flag.
        /// </summary>
        public static bool HasHeaderImage
        {
            get
            {
                using (MvcBasicSiteEntities dataContext = new MvcBasicSiteEntities())
                {
                    SiteSetting siteSetting = dataContext.SiteSettings.First();
                    //
                    return (siteSetting.HeaderImage != null);
                }
            }
        }
        /// <summary>
        /// Gets the Header Description.
        /// </summary>
        public static string HeaderDescription
        {
            get
            {
                using (MvcBasicSiteEntities dataContext = new MvcBasicSiteEntities())
                {
                    SiteSetting siteSetting = dataContext.SiteSettings.First();
                    //
                    return (string.IsNullOrEmpty(siteSetting.SiteTitle) ? Resources.Resource.HeaderTitle : siteSetting.HeaderDescription);
                }
            }
        }

        /// <summary>
        /// Activate the edit view.
        /// </summary>
        /// <remarks>
        /// GET: /SiteSetting/Edit/5
        /// </remarks>
        /// <param name="id"></param>
        /// <returns></returns>
        public ActionResult Edit(int id = 1)
        {
            SiteSetting sitesetting = _db.SiteSettings.Single(s => s.ID == id);
            if (sitesetting == null)
            {
                return HttpNotFound();
            }
            //
            return View(sitesetting);
        }

        /// <summary>
        /// Postback action for saving the site settings.
        /// </summary>
        /// <remarks>
        /// POST: /SiteSetting/Edit/5
        /// </remarks>
        /// <param name="sitesetting"></param>
        /// <param name="address"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult Edit(SiteSetting sitesetting, Address address)
        {
            sitesetting.Address = address;
            //
            if (ModelState.IsValid)
            {
                _db.SiteSettings.Attach(sitesetting);
                _db.ObjectStateManager.ChangeObjectState(sitesetting, EntityState.Modified);
                _db.SaveChanges();
                //
                return RedirectToAction("Index", "VisitorLog");
            }
            //
            return View(sitesetting);
        }

        /// <summary>
        /// Upload header image file and seved it into the database.
        /// </summary>
        /// <param name="uploadFile">The uploaded file metadata.</param>
        /// <returns>The view result.</returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UploadHeaderImage(HttpPostedFileBase uploadFile)
        {
            if (uploadFile != null && uploadFile.ContentLength > 0)
            {
                //
                // Read the image file data, Resize the image and save the result into the database.
                //
                Stream fileStream = uploadFile.InputStream;
                //
                System.Drawing.Image image = System.Drawing.Image.FromStream(fileStream);
                System.Drawing.Bitmap newImage = ImageUtilities.ResizeImage(image, 260, 124);
                fileStream.Close();
                //
                MemoryStream ms = new MemoryStream();
                Stream stream = ImageUtilities.SaveJpeg(ms, newImage, 100);
                //
                stream.Seek(0, SeekOrigin.Begin);
                try
                {
                    //
                    // Read the resized image file data.
                    //
                    byte[] fileData = new byte[stream.Length];
                    stream.Read(fileData, 0, (int)stream.Length);
                    //
                    // Save the data into the database.
                    //
                    SiteSetting shopSetting = _db.SiteSettings.First();
                    //
                    shopSetting.HeaderImage = fileData;
                    _db.SaveChanges();
                }
                finally
                {
                    stream.Close();
                }
            }
            //
            return RedirectToAction("Index", "VisitorLog");
        }

        /// <summary>
        /// Get the header image from database.
        /// </summary>
        /// <param name="ID">The image ID is not used!</param>
        /// <returns>The image result.</returns>
        public ImageResult GetHeaderImage(int id)
        {
            SiteSetting shopSetting = _db.SiteSettings.First();
            //
            return this.Image(shopSetting.HeaderImage, "image/jpeg");
        }

        /// <summary>
        /// Use the default header image.
        /// </summary>
        public ActionResult DefualtHeaderImage()
        {
            SiteSetting shopSetting = _db.SiteSettings.First();
            //
            shopSetting.HeaderImage = null;
            _db.SaveChanges();
            //
            return RedirectToAction("Index", "VisitorLog");
        }


    }
}