﻿#region Copyright (c) 2013 Raul Iloc
/*
{***************************************************************************}
{                                                                           }
{       Copyright (c) 2010  RAUL ILOC (rauliloc@yahoo.com)                  }
{       ALL RIGHTS RESERVED                                                 }
{                                                                           }
{   THE WORK IS PROVIDED UNDER THE TERMS OF THIS CODE PROJECT OPEN LICENSE. }
{   THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.         }
{   ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE         }
{   OR COPYRIGHT LAW IS PROHIBITED.                                         }
{                                                                           }
{                                                                           }
{  BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HEREIN, YOU ACCEPT AND     }
{  AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. THE AUTHOR GRANTS YOU    }
{  THE RIGHTS CONTAINED HEREIN IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH  }
{  TERMS AND CONDITIONS. IF YOU DO NOT AGREE TO ACCEPT AND BE BOUND BY THE  }
{  TERMS OF THIS LICENSE, YOU CANNOT MAKE ANY USE OF THE WORK.              }
{                                                                           }
{***************************************************************************}
*/
#endregion Copyright (c) 2013 Raul Iloc
using System;
using System.Collections.Generic;
using System.Linq;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the user roles.
    /// </summary>
    public enum UserRoles : short
    {
        Administrator = 1,
        SimpleUser = 2,
    }

    /// <summary>
    /// Defines the user entity.
    /// </summary>
    [MetadataType(typeof(UserValidation))]
    public partial class User
    {
        /// <summary>
        /// Gets or sets the comfirm password.
        /// </summary>
        public string ComfirmPassword { get; set; }
        /// <summary>
        /// Gets or sets the confirm email.
        /// </summary>
        public string ComfirmEmail { get; set; }
        /// <summary>
        /// Gets or sets the user role.
        /// </summary>
        public UserRoles UserRole
        {
            get { return (UserRoles)this.Role; }
            set { this.Role = (short)value; }
        }

        /// <summary>
        /// Gets normal search count.
        /// </summary>
        /// <remarks>
        /// This is used only to simulate an expected exception!
        /// </remarks>
        /// <param name="dataContext">The data context.</param>
        /// <param name="userID">The ID of the current user.</param>
        /// <param name="parameters">The search parameters.</param>
        /// <returns></returns>
        public static int GetNormalSearchCount(int userID, params object[] parameters)
        {
            MvcBasicSiteEntities dataContext = null;
            //
            try
            {
                dataContext = new MvcBasicSiteEntities();
                return dataContext.ExecuteStoreCommand("GetNormalSearchCount", parameters);
            }
            catch (System.Data.SqlClient.SqlException exception)
            {
                // 
                // Manage the SQL expected exception by generating a MvcBasicException 
                // with more info added to the orginal exception.
                //
                throw new MvcBasicException(string.Format("GetNormalSearchCount for user: {0}", userID), exception);
            }
            finally
            {
                //
                // Dispose the used resource.
                //
                if(dataContext != null)
                    dataContext.Dispose();
            }
        }
    }


    /// <summary>
    /// Defines the validation rules and messages for user entity.
    /// </summary>
    public class UserValidation
    {
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(50)]
        public string Username { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Password)]
        [StringLength(50)]
        public string Password { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Compare("Password", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "UserComfirmPasswordValidation")]
        [DataType(DataType.Password)]
        [StringLength(50)]
        public string ComfirmPassword { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Email(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationEmail")]
        [DataType(DataType.EmailAddress)]
        [StringLength(128)]
        public string Email { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Email(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationEmail")] 
        [Compare("Email", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationComfirmEmail")]
        [DataType(DataType.EmailAddress)]
        [StringLength(128)]
        public string ComfirmEmail { get; set; }
    }
}
