﻿using System;
using System.Web;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;
//
using Resources;

namespace MvcBasicSite.Models
{
    /// <summary>
    /// Defines the Log On model.
    /// </summary>
    public class LogOnModel
    {
        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        public string Username { get; set; }
        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Password)]
        public string Password { get; set; }
    }
}