﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the user roles.
    /// </summary>
    public enum UserRoles : short
    {
        Administrator = 1,
        SimpleUser = 2,
    }

    /// <summary>
    /// Defines the user entity.
    /// </summary>
    [MetadataType(typeof(UserValidation))]
    public partial class User
    {
        /// <summary>
        /// Gets or sets the comfirm password.
        /// </summary>
        public string ComfirmPassword { get; set; }
        /// <summary>
        /// Gets or sets the confirm email.
        /// </summary>
        public string ComfirmEmail { get; set; }
        /// <summary>
        /// Gets or sets the user role.
        /// </summary>
        public UserRoles UserRole
        {
            get { return (UserRoles)this.Role; }
            set { this.Role = (short)value; }
        }
    }


    /// <summary>
    /// Defines the validation rules and messages for user entity.
    /// </summary>
    public class UserValidation
    {
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(50)]
        public string Username { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Password)]
        [StringLength(50)]
        public string Password { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Compare("Password", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "UserComfirmPasswordValidation")]
        [DataType(DataType.Password)]
        [StringLength(50)]
        public string ComfirmPassword { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Email(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationEmail")]
        [DataType(DataType.EmailAddress)]
        [StringLength(128)]
        public string Email { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [Email(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationEmail")] 
        [Compare("Email", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationComfirmEmail")]
        [DataType(DataType.EmailAddress)]
        [StringLength(128)]
        public string ComfirmEmail { get; set; }
    }
}
