﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the email validation attribute.
    /// </summary>
    public class EmailAttribute : RegularExpressionAttribute, IClientValidatable
    {
        /// <summary>
        /// Initializes a new instance of the EmailAttribute class.
        /// </summary>
        public EmailAttribute()
            : base(@"^([a-zA-Z0-9_äöüÄÖÜßăîâșțĂÎÂȘȚ\-\.]+)@((\[[0-9]{1,3}" +
                   @"\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9äöüÄÖÜßăîâșțĂÎÂȘȚ\-]+\" +
                   @".)+))([a-zA-ZäöüÄÖÜßăîâșțĂÎÂȘȚ]{2,4}|[0-9]{1,3})(\]?)$")
        {
        }

        /// <summary>
        /// Get the client validation rules.
        /// </summary>
        /// <param name="metadata">The model metadata.</param>
        /// <param name="context">The controller context.</param>
        /// <returns>The client validation rules for this validator.</returns>
        public IEnumerable<ModelClientValidationRule> GetClientValidationRules(ModelMetadata metadata, ControllerContext context)
        {
            string errorMessage = FormatErrorMessage(metadata.GetDisplayName());
            yield return new EmailValidationRule(errorMessage);
        }
    }

    /// <summary>
    /// Defines the email validation rule.
    /// </summary>
    public class EmailValidationRule : ModelClientValidationRule
    {
        /// <summary>
        /// Initializes a new instance of the EmailValidationRule class.
        /// </summary>
        /// <param name="errorMessage">The error message.</param>
        public EmailValidationRule(string errorMessage)
        {
            this.ErrorMessage = errorMessage;
            this.ValidationType = "email";
        }
    }
}
