﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using System.Data;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the country entity.
    /// </summary>
    public partial class Country
    {
        /// <summary>
        /// Get countries list ready to be used in UI. 
        /// </summary>
        /// <param name="dataContext">The data context.</param>
        public static List<SelectListItem> GetCountryList(MvcBasicSiteEntities dataContext)
        {
            List<SelectListItem> list = new List<SelectListItem>();
            //
            SelectListItem selectItem = new SelectListItem();
            //
            foreach (Country country in dataContext.Countries)
            {
                selectItem = new SelectListItem { Text = country.Name, Value = country.ID.ToString() };
                //
                list.Add(selectItem);
            }
            //
            return list;
        }
    }
}
