﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.DataAnnotations;
using System.Collections;
using System.Web.Mvc;

namespace MvcBasic.Logic
{
    /// <summary>
    /// Defines the address entity.
    /// </summary>
    [MetadataType(typeof(AddressValidation))]
    public partial class Address
    {

        /// <summary>
        /// Initializes a new instance of the Address class.
        /// </summary>
        public Address()
        {
            this.ID = 0;
        }
    }

    /// <summary>
    /// Defines the validation rules and messages for address entity.
    /// </summary>
    public class AddressValidation
    {
        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(50)]
        public string FirstName { get; set; }

        [DataType(DataType.Text)]
        [StringLength(50)]
        public string LastName { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [RegularExpression(@"([A-Za-zäöüÄÖÜßăîâșțĂÎÂȘȚ\.\\/ ])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationNumbersNotAllowed")]
        [DataType(DataType.Text)]
        [StringLength(100)]
        public string Town { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [DataType(DataType.Text)]
        [StringLength(200)]
        public string Street { get; set; }

        [RegularExpression(@"([0-9 \.\(\)/\\\-\+])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.PhoneNumber)]        
        [StringLength(25)]
        public string Phone { get; set; }

        [RegularExpression(@"([0-9 \.\(\)/\\\-\+])+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.PhoneNumber)]
        [StringLength(25)]
        public string Fax { get; set; }

        [Required(ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationRequired")]
        [RegularExpression(@"(\d)+", ErrorMessageResourceType = typeof(Resource), ErrorMessageResourceName = "ValidationLettersNotAllowed")]
        [DataType(DataType.Text)]
        [StringLength(25)]
        public string ZipCode { get; set; }
    }

    
}
