<?
/*
Class:    CTable
Author:   David Higgins
Written:  10/20/2002

About:    This class is designed to ease the pain of generating table output from databases
*/

class CTable {
  var $headers;
	var $footers;
	var $rows;
	var $cells;
	var $cells_d;
	
  // constructor
  function CTable() {
	  $this->headers = "";
		$this->footers = "";
		$this->rows = 0;
		$this->cells = 0;
	  //$this->rows_d = array();
		$this->cells_d = array();
	}

  // output the table
	function Generate() {
	  echo "<table" . ($this->headers=''?'':'' . ' ' . $this->headers) . ">\n";
		for($r=1; $r <= $this->rows; $r++) {
			echo "<tr" . (isset($this->cells_d[$r]['header'])?' ' . $this->cells_d[$r]['header']:'') . ">\n";
		  for($c=1; $c <= $this->cells; $c++) {
				//echo "  <td" . (isset($cells_h['r' . $r . '_c' . $c])?($cells_h['r' . $r . '_c' . $c]==''?'':' ' . $cells_h['r' . $r . '_c' . $c]):'') . ">";
				echo "  <td" . (isset($this->cells_d[$r][$c]['header'])?' ' . $this->cells_d[$r][$c]['header']:'') . ">";
				echo (isset($this->cells_d[$r][$c]['data'])?$this->cells_d[$r][$c]['data']:'&nbsp;');
				echo "</td>\n";
			}
			echo "</tr>\n";
		}
		echo $this->footers . "\n</table>\n";
	}

  // change the table class
	function setClass($class) {
		$this->headers .= " class=\"$class\"";
	}
	
  // change the tables border
	function setBorder($border) {
		$this->headers .= " border=\"$border\"";
	}
	
  // change the tables width
	function setWidth($width) {
		$this->headers .= " width=\"$width\"";
	}
	
  // change the tables width
	function setCellspacing($cellspacing) {
		$this->headers .= " cellspacing=\"$cellspacing\"";
	}
	
  // change the tables cellpadding
	function setCellpadding($cellpadding) {
		$this->headers .= " cellpadding=\"$cellpadding\"";
	}

  // get the table attributes
	function GetHeader() {
	  return $this->headers;
	}
	
  // set the table attributes (manual version of the above)
	function SetHeader($header) {
	  $this->headers = $header;
	}
	
  // get the table footer
  //
  // the table footer is additional data added after the rows/cell but BEFORE the </table> tag
  // I do not know of any particular use for this ... other then possibly debug information
	function GetFooter() {
	  return $this->footers;
	}
	
  // set the table footer
	function SetFooter($footer) {
	  $this->footers = $footer;
	}
	
  // define the number of rows in the table
	function Rows($r) {
	  if(is_numeric($r)) {
			if($r > 0) {
				$this->rows = $r;
			} else {
			  echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR: You did not specify a valid Row value!<br></div>\n";
			}
		} else {
		  echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR: You did not specify a numeric Row value!<br></div>\n";
		}
	}
	
  // get the number of rows defined for this table
	function GetRows() {
	  return $this->rows;
	}
	
  // define the number of cells in this table
	function Cells($c) {
	  if(is_numeric($c)) {
			if($c > 0) {
				$this->cells = $c;
			} else {
			  echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR: You did not specify a valid Row value!<br></div>\n";
			}
		} else {
		  echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR: You did not specify a numeric Row value!<br></div>\n";
		}
	}	
	
  // get the number of cells defined for this table
	function GetCells() {
	  return $this->cells;
	}
	
  // set the data contained within the cell in row $r location $c
	function SetData($data, $r, $c) {
		// always a cell
		if(!is_numeric($r) || !is_numeric($c)) { 
		  // error
			echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData): You did not specific a valid Row or Cell reference!<br></div>\n";
		} else { 
			if($r > $this->rows || $r < 1) { 
				// error
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData): You did not specify a numeric Row reference!<br></div>\n";
			} else {
			  if($c > $this->cells || $c < 1) {
					// error
					echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData ! " . $this->cells . " ! $c): You did not specify a numeric Cell reference!<br></div>\n";
				} else {
					$this->cells_d[$r][$c]['data'] = $data;
				}
			}
		}
	}
	
  // get the data contained within a cell
	function GetData($r, $c) {
    if(!is_numeric($r) || !is_numeric($c)) {
      // error
      echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData): You did not specific a valid Row or Cell reference!<br></div>\n";
    } else {
      if($r > $this->rows || $r < 1) {
      // error
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData): You did not specify a numeric Row reference!<br></div>\n";
			} else {
			  if($c > $this->cells || $c < 1) {
					// error
					echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetData ! " . $this->cells . " ! $c): You did not specify a numeric Cell reference!<br></div>\n";
				} else {
					$return this->cells_d[$r][$c]['data'];
				}
			}
		}
	}

  // set the attributes for the TR or TD
  // if $c is optional, if not passed ... it sets the row attributes, else the cell attributes
	function SetHeader($header, $r, $c=false) {
		if(is_bool($c)) {
		  // Row Header
			if(is_numeric($r)) { 
				$this->cells_d[$r]['header'] = $header;
			} else {
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader ! is_bool): You did not specify a numeric Row reference!<br></div>\n";
			}
		} else {
		  // Cell Header
			if(is_numeric($r)) { 
				if(is_numeric($c)) {
					$this->cells_d[$r][$c]['header'] = $header;
				} else {
					echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader): You did not specify a numeric Cell reference!<br></div>\n";
				}
			} else {
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader): You did not specify a numeric Row reference!<br></div>\n";
			}
		}
	}
	
  // retrieve the attributes for a cell or row
	function GetHeader($r, $c=false) {
		if(is_bool($c)) {
		  // Row Header
			if(is_numeric($r)) {
				return $this->cells_d[$r]['header']; // = $header;
			} else {
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader ! is_bool): You did not specify a numeric Row reference!<br></div>\n";
			}
		} else {
		  // Cell Header
			if(is_numeric($r)) {
				if(is_numeric($c)) {
					return $this->cells_d[$r][$c]['header']; // = $header;
				} else {
					echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader): You did not specify a numeric Cell reference!<br></div>\n";
				}
			} else {
				echo "<div style=\"color: #DD0000;  background: #222222; border:  thin solid #338833;\">ERROR(SetHeader): You did not specify a numeric Row reference!<br></div>\n";
			}
		}
	}
	
  // this function is for development purposes only
  // it outputs the data contained within the cells_d variable
	function Debug() {
		echo "<br><br>DEBUG:<br>\n";
		echo "cells_d = "; var_dump($this->cells_d);

	}

  // this function frees up some memory ... its not neccessary for anything ...
  // just here to be here ...
  function Release() {
    $this->headers = null;
    $this->footers = null;
    $this->rows = null;
    $this->cells = null;
    $this->cells_d = null;
    return true;
  }
}
?>