<?php
require_once('cspfilter_class.php');
$htmlfile = "README.html";
$buffer = file_get_contents($htmlfile);

$domdoc = new DOMDocument("1.0","utf-8");
$domdoc->preserveWhiteSpace = false;
$domdoc->formatOutput = true;
$domdoc->loadHTML($buffer);

$filter = new cspfilter($domdoc);
$filter->csp['allow'] = 'none';
$filter->csp['img-src'] = 'www.w3.org';

$filter->processData();
$filter->makeCSP();

// ignore this part of the source - I'm modifying the README.html
//  content to insert actual example of policy violation report
$report = $filter->displayViolationReport();
$reportNode = $domdoc->createElement("pre",$report);
$reportNode->setAttribute("class","cspreport");
$elements = $domdoc->getElementsByTagName("pre");
foreach ($elements as $element) {
   if ($element->hasAttribute('id')) {
      $id = $element->getAttribute('id');
      if ($id == 'treport') {
         $element->parentNode->replaceChild($reportNode,$element);
         }
      }
   }
// end ignore

print $domdoc->saveHTML();
?>