onHTML
------

Project - proof of concept, a dynamic page generation toolkit.

Aim is to create a kit for dynamic web apps which would use JSON as main com protocol making it easier to base multiple front ends upon a single back-end API, for example, browser extensions, desktop and mobile apps, and more without using different backend presentation logic for each frontend type.

**Overall functionality so far:**

 - Basic jQuery JSON to HTML renderer. Supports event binding, attributes, CSS styling and load event callback, right from the JSON output. See test.html for example use.
 - PHP JSON generator. See php/data.php for example use.

**Methods provided by onHTML PHP class:**

 - **__construct**: create new element.
 - **setIndexing**: set element indexing on or off.
 - **addElement**: add new child element for current element.
 - **addChild**: add existing onHTML object as child for current element.
 - **addLoadCallback**: register front-end JS function name as load callback for current element.
 - **addClass**: add one or more classes to current element.
 - **removeClass**: remove one or more classes from current element.
 - **attr**: add one or more attributes to element.
 - **removeAttr**: remove attribute from element.
 - **bind**: register one or more front-end JS function names as a event callbacks.
 - **css**: set one or multiple css property's.
 - **getElementsByClassName**: get collection of elements from global collection by class. Requires indexing to be on.
 - **getElementsByTagName**: get collection of element from global collection by tag name. Requires indexing to be on.
 - **getElementById**: get specific element by ID. Requires indexing to be on.
 - **getElementByOID**: get element by object ID (this is not spl_object_hash). Requires indexing to be on.
 - **json**: generate and return JSON output. 

By default, indexing is off. 

**Some stats and numbers:**

 - Generation and load time (10 000 elements): ~0.3sec AVG from 100 requests.
 - Render time (10 000 elements, including gen./load time): ~0.5sec AVG from 100 requests.

Tested on a AMD Phenom 2 x4 notebook, with 4GB of RAM, Chrome 20.0, Windows 8 and Zend Server CE (PHP 5.3.9-ZS5.6.0) (data cache and optimizer off). Results on different setups may vary.

It is possible to cache PHP rendered JSON inside a Memcached or other caching engine with ease and even compress it as GZIP, so load latency could be improved greatly.


