﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<YaBlogEngineMVC.Models.ViewModels.PaginatedViewBlogList>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    <%:ViewData["Message"] %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <h2>
        <%:ViewData["Message"] %>
    </h2>
    Showing page <strong><%: Model.PageIndex + 1 %></strong> of <strong><%: Model.TotalPages %></strong>

    <%foreach (YaBlogEngineMVC.Models.ViewModels.ViewBlogViewModel item in Model)
      { %>
    <p>
        <h3>
            <%: Html.ActionLink(item.Blog.Subject, "Details", new {  id=item.Blog.ID  })%>
        </h3>
        <%: item.Blog.BlogSummary %>
        <br />
        <br />
        Posted under: <strong>
            <%: item.CategoryName %></strong>, <strong>
                <%: item.CommentCount %></strong> Comments<br />
        Posted by <strong>
            <%:item.Blog.PostedBy %></strong> on <strong>
                <%: item.Blog.DatePosted %></strong>
        <br />
        <br />
        <%: Html.ActionLink("Read More", "Details", new {  id=item.Blog.ID  })%>
    </p>
    <hr />
    <%} %>
    <%if (Model.HasPreviousPage == true)
      { %>
    <%: Html.ActionLink("Previous Page", "Index", new { id = Model.PageIndex - 1, catagoryId = Request.QueryString["catagoryId"]})%>
    &nbsp; | &nbsp;
    <%} %>
    <%if (Model.HasNextPage == true)
      { %>
    <%: Html.ActionLink("Next Page", "Index", new { id = Model.PageIndex + 1, catagoryId = Request.QueryString["catagoryId"] })%>
    <%} %>
</asp:Content>
