﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<YaBlogEngineMVC.Models.ViewModels.ViewBlogViewModel>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
     <%: Model.Blog.Subject %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <h2>
        <%: Model.Blog.Subject %>
    </h2>
    <p>
        Posted by:
        <%: Model.Blog.PostedBy %>
        on
        <%: Model.Blog.DatePosted %>
        <br />
        <br />
        <br />
        <%: Model.Blog.Body %>
    </p>
    <p>
        <%: Model.CommentCount %>
        Comments on this post
    </p>
    <% if (Request.IsAuthenticated)
       {
           if (User.Identity.Name == Model.Blog.PostedBy)
           {%>
           <%: Html.ActionLink("Edit your Blog", "Edit", new {id = Model.Blog.ID}) %>
           &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; 
           <%: Html.ActionLink("Delete your Blog", "Delete", new {id = Model.Blog.ID}) %>

    <%} using (Html.BeginForm("AddComment", "Blog", new { id = Model.Blog.ID }, FormMethod.Post))
           {%>
    <% Html.RenderPartial("AddComment", new YaBlogEngineMVC.Models.Comment()); %>
    <%} %>
    <%} %>
    <h3>
        Comments (<%: Model.CommentCount %>)
    </h3>
    <%foreach (YaBlogEngineMVC.Models.Comment c in Model.Comments)
      { %>
    <p>
        <%: c.Comment1 %>
        <hr />
        Posted by
        <%: c.Name %>
        on
        <%: c.DatePosted %>
    </p>
    <%} %>
</asp:Content>
