﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace YaBlogEngineMVC.Models
{
    public class CategoryRepository : ICategoryRepository
    {
        yaBlogDbEntities entities = null;

        public CategoryRepository(yaBlogDbEntities entities)
        {
            this.entities = entities;
        }

        public List<Category> GetCategories()
        {
            return entities.Categories.ToList();
        }

        public void AddCategory(Category category)
        {
            entities.Categories.AddObject(category);
        }

        public Category GetCategoryById(int id)
        {
            Category category = entities.Categories.SingleOrDefault(c => c.ID == id);

            return category;
        }
               
        public void Save()
        {
            entities.SaveChanges();
        }
    }
}