﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using YaBlogEngineMVC.Models.ViewModels;

namespace YaBlogEngineMVC.Models
{
    public class BlogRepository : IBlogRepository
    {
        yaBlogDbEntities entities = null;

        public BlogRepository(yaBlogDbEntities entities)
        {
            this.entities = entities;
        }

        void IBlogRepository.AddBlog(Blog blog)
        {
            entities.Blogs.AddObject(blog);
        }

        public Blog GetBlogById(int id)
        {
            return entities.Blogs.SingleOrDefault(b => b.ID == id);
        }

        public IQueryable<Blog> GetBlogs(int categoryId)
        {
            // no category filter needed, show all blogs
            if (categoryId == 0)
            {
                return from b in entities.Blogs
                       orderby b.DatePosted descending
                       select b;
            }

            // category filter is needed
            return from b in entities.Blogs                   
                   orderby b.DatePosted descending
                   where b.CategoryId == categoryId
                   select b;
        }

        public List<CategoryListViewModel> GetActiveCategories()
        {
            return (from b in entities.Blogs
                        group b by b.Category into g
                        select new CategoryListViewModel
                        {
                            Category = g.Key,
                            BlogCount = g.Count()
                        }).ToList();
        }

        public void RemoveBlog(Blog blog)
        {   
            entities.Blogs.DeleteObject(blog);
        }

        public void Save()
        {
            entities.SaveChanges();
        }
    }
}