﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace YaBlogEngineMVC.Models
{
    [MetadataType(typeof(BlogMetaData))]
    public partial class Blog
    {
        // This will give us the summary of blog which will be displayed on main page
        public string BlogSummary
        {
            get
            {
                if (this.Body.Length < 100)
                {
                    return this.Body;
                }
                else
                {
                    return string.Format("{0} ...", this.Body.Substring(0, 100));
                }
            }           
        }
    }

    // These will facilitate unobtrusive validations
    public class BlogMetaData
    {
        [Required(ErrorMessage="Subject is required before posting a blog")]
        public string Body { get; set; }

        [Required(ErrorMessage = "Blog content is required before posting a blog")]        
        public string Subject { get; set; }
    }
}