﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

namespace TddMvcSample.Models
{
    public class BooksRepository : IBooksRepository
    {
        SampleDatabaseEntities entities = null;        

        public BooksRepository(SampleDatabaseEntities entities)
        {
            this.entities = entities;
        }

        public List<Book> GetAllBooks()
        {
            return entities.Books.ToList();
        }

        public Book GetBookById(int id)
        {
            return entities.Books.SingleOrDefault(book => book.ID == id);
        }

        public void AddBook(Book book)
        {
            entities.Books.AddObject(book);
        }

        public void UpdateBook(Book book)
        {
            entities.Books.Attach(book);
            entities.ObjectStateManager.ChangeObjectState(book, EntityState.Modified);
        }

        public void DeleteBook(Book book)
        {
            entities.Books.DeleteObject(book);
        }

        public void Save()
        {
            entities.SaveChanges();
        }
    }
}