﻿// This file contains the javascript methods for the usual validation scenarios
// encountered in a typical web form based website. it contains the functions
// to restrict the user input in case the user want to take the preemtive approach.
// Also, the validation functions to check for proper input before submitting the 
// page are also present in this file only - Rahul Singh (Rahul Rajat Singh)

//Function to create textbox based on regular expressions
function AcceptRegExOnly(event, regex)  
{   
    var keyCode = event.which ? event.which : event.keyCode;
    
    var keyPressed = String.fromCharCode(keyCode);
    return regex.test(keyPressed);
}; 
// Note: Many other functions in this file can 
// be implemented in terms of this function. 


//Function to create alphabetic text box only - using keycodes
function AcceptAlphabetsOnly(event, allowSpaces) 
{
    var keyCode = event.which ? event.which : event.keyCode;
    
    if (    (keyCode >= 97 && keyCode <= 122) ||        //lets allow for the small alphabets
            (keyCode >= 65 && keyCode <= 90)  ||        //Let us allow the capital letters too
            ((allowSpaces == true) && (keyCode == 32))  //allow space conditionally based on the control's choice
       )
    {
        return true;
    }
    
    return false;
};

//Function to create alphabetic text box only - using regex
function AcceptAlphabetsOnlyEx(event, allowSpaces) 
{
    if(allowSpaces == true)
    {
        return AcceptRegExOnly(event, /^[a-zA-Z ]$/);
    }
    return AcceptRegExOnly(event, /^[a-zA-Z]$/);
};


//Function to create numeric text box only - using keycodes
function AcceptNumericOnly(event, allowPeriod) 
{
    var keyCode = event.which ? event.which : event.keyCode;    
    
    if( (keyCode >= 48 && keyCode <= 57) ||         //lets allow only numerics 
        ((allowPeriod == true) && (keyCode == 46))  //allow period conditionally based on the control's choice
      )
    {
        return true;
    }   
    
    return false;
};

//Function to create numeric text box only - using regex
function AcceptNumericOnlyEx(event, allowPeriod) 
{  
    if(allowPeriod == true)
    {
        return AcceptRegExOnly(event, /^[0-9.]$/);
    }
    return AcceptRegExOnly(event, /^[0-9]$/);
};


//Function to create alphanumeric text box - using keycodes
function AcceptAlphaNumericOnly(event, allowSpaces, allowPeriod)  
{
    if( (AcceptAlphabetsOnly(event, allowSpaces) == true) ||    //Create alphabetic text box
        (AcceptNumericOnly(event, allowPeriod) == true)         //Create numeric text box
      )
    {
        return true;
    }
    
    return false;
};


//Function to create alphanumeric text box - using regex
function AcceptAlphaNumericOnlyEx(event, allowSpaces, allowPeriod) 
{
    if(allowSpaces == true && allowPeriod == false)
    {
        return AcceptRegExOnly(event, /^[a-zA-Z0-9 ]$/);
    }
    if(allowPeriod == true && allowSpaces == false)
    {
        return AcceptRegExOnly(event, /^[a-zA-Z0-9.]$/);
    }
    if(allowPeriod == true && allowSpaces == true)
    {
       return AcceptRegExOnly(event, /^[a-zA-Z0-9 .]$/);
    }
    
    return AcceptRegExOnly(event, /^[a-zA-Z0-9]$/);
};

//This function will create the date text box
function AcceptDateCharacters(event, separator)
{
    if(separator.length != 1)  //only pass single character separators here
    {
        return false;
    }
    //lets allow digits
    var expression = "^[0-9";
    
    //lets allow the separator character
    expression += separator;
    
    //lets complete the expression
    expression += "]$";
    
    var regex = new RegExp(expression);    
    return AcceptRegExOnly(event, regex)  
};


//This function will check for the mandatory field
function CheckMandatoryInput(input)
{   
    if(input.value.length == 0)
    {   
        input.style.borderColor="Red";
        input.title = "This field is mandatory";
        return false;
    }
    
    input.style.borderColor="";
    input.title = "";
    return true;
};


//This function will check for the input using regular expression
function CheckWithRegExp(input, regex, mandatory)
{
    if(mandatory == true && CheckMandatoryInput(input) == false)
    {
        return false;
    }
    if(regex.test(input.value) == false)  
    {
        input.style.borderColor="Red";
        input.title = "This is not a valid input";
        return false;
    }    
    
    input.style.borderColor="";
    input.title = "";
    return true;
};