<?php

/**
 * Class to get gravatar profile's information.
 * 
 * @copyright Lellys Informáica
 * @author Ítalo Lelis de Vietro
 * @link http://www.lellysinformatica.com
 * 
 * @version 1.0
 * 
 * @license GNU General Public License, version 3 (GPL-3.0)
 * @see http://www.opensource.org/licenses/gpl-3.0.html
 */
class easy_gravatar {

    private $email = "";
    private $profile = array();

    /**
     * Inicialize a new instance of easy_gravatar class.
     * @param string a valid email
     */
    public function __construct($email) {
        $this->email = $email;
        $this->requestURL();
    }

    /**
     * Request the gravatar information.
     * Note: The information is serializable, so we need to use the unserialize function.
     * @see http://php.net/manual/en/function.unserialize.php
     */
    private function requestURL() {
        $str = file_get_contents('http://www.gravatar.com/' . $this->encodeMail($this->email) . ".php'");
        $temp = unserialize($str);
        if (is_array($this->profile) && isset($this->profile['entry']))
            $this->profile = $temp;
    }

    /**
     * Used to encode the email, we're are using the md5 encoding. 
     * 
     * @param string $email
     * @return string
     */
    private function encodeMail($email) {
        return md5(strtolower(trim($email)));
    }

    /**
     * Get the Display Name
     * @return string 
     */
    public function getDisplayName() {
        if (is_array($this->profile) && isset($this->profile['entry']))
            return $this->profile['entry'][0]['displayName'];
    }

    /**
     * Get the First Name
     * @return string 
     */
    public function getGivenName() {
        return $this->profile['entry'][0]['name']['givenName'];
    }

    /**
     * Get the Last Name
     * @return string 
     */
    public function getFamilyName() {
        return $this->profile['entry'][0]['name']['familyName'];
    }

}

?>
