<?php

/**
 * 
 * Copyright (c) 2010, eBussola.com All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the eBussola.com.
 * 4. Neither the name of the eBussola.com nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY EBUSSOLA.COM ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL EBUSSOLA.COM BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * configs:
 *   user:string
 *     type:[uploads|favorites]
 *   playlist:string
 *   video:string
 * 
 * @author Leonardo Branco Shinagawa <leonardo@ebussola.com>
 *
 */
class Feedee_Youtube implements IteratorAggregate
{
	
	private $channel;
	private $items;
	private $url = 'http://gdata.youtube.com/feeds/base/users/%s/%s?alt=rss&amp;v=2&amp;orderby=published&amp;client=ytapi-youtube-profile';
	private $urlPlaylist = 'http://gdata.youtube.com/feeds/api/playlists/%s?v=2';
	private $urlVideo = 'http://www.youtube.com/oembed?url=%s';
	private $config;
	private $entries;
	
	public function __construct($config)
	{
		$this->config = $config;
		$this->getFeed();
	}
	
	private function getFeed()
	{
		if (isset($this->config['user']) && !is_null($this->config['user']))
		{
                        $expire = isset($this->config['expire']) ? $this->config['expire'] : 3600;
			$type = isset($this->config['type']) ? $this->config['type'] : 'uploads';
			if ($type != 'uploads' && $type != 'favorites')
				throw new Exception("Invalid TYPE {$type}");
			$url = sprintf($this->url, $this->config['user'], $type);
			$xml = simplexml_load_string(Feedee::getHttp($url, $expire));
			$this->channel = $xml->channel;
			foreach ($this->channel->item as $item)
				$this->entries[] = new Feedee_Youtube_Entry($item);
		}
		elseif (isset($this->config['playlist']) && !is_null($this->config['playlist']))
		{
                        $expire = isset($this->config['expire']) ? $this->config['expire'] : 3600;
			$url = sprintf($this->urlPlaylist, $this->config['playlist']);
			$xml = simplexml_load_string(Feedee::getHttp($url, $expire));
			foreach ($xml->entry as $item)
				$this->entries[] = new Feedee_Youtube_Playlist_Entry($item);
		}
		elseif (isset($this->config['video']) && !is_null($this->config['video']))
		{
                        $expire = isset($this->config['expire']) ? $this->config['expire'] : 43200;
			$url = sprintf($this->urlVideo, $this->config['video']);
			$json = Feedee::getHttp($url, $expire);
			$this->entries = new Feedee_Youtube_Video($json, $this->config['video']);
		}
	}
	
	public function getIterator()
	{
		if (isset($this->config['video']) && !is_null($this->config['video']))
			return $this->entries;
		else
			return new ArrayIterator($this->entries);
	}
	
}

class Feedee_Youtube_Playlist_Entry extends Feedee_Entry
{
	
	private $entry;
	
	public $width = 640;
	public $height = 385;
	
	public function __construct($entry)
	{
		$this->entry = $entry;
	}
	
	public function getTitle()
	{
		return $this->entry->title;
	}
	
	public function getLink()
	{
		return $this->entry->link['href'];
	}
	
	public function getAuthor()
	{
		return $this->entry->author->name;
	}
	
	public function getAuthorLink()
	{
		return $this->entry->author->uri;
	}
	
	public function getEmbed($width=null, $height=null)
	{
		if (is_null($width))
			$width = $this->width;
		if (is_null($height))
			$height = $this->height;
		return Feedee_Youtube_Tools::getEmbed(Feedee_Youtube_Tools::getVideoId($this->link), $width, $height);
	}
	
}

class Feedee_Youtube_Entry extends Feedee_Entry
{
	
	private $entry;
	
	public $width = 640;
	public $height = 385;
	
	public function __construct($entry)
	{
		$this->entry = $entry;
	}
	
	public function getTitle()
	{
		return $this->entry->title;
	}
	
	public function getLink()
	{
		return $this->entry->link;
	}
	
	public function getEmbed($width=null, $height=null)
	{
		if (is_null($width))
			$width = $this->width;
		if (is_null($height))
			$height = $this->height;
		return Feedee_Youtube_Tools::getEmbed(Feedee_Youtube_Tools::getVideoId($this->link), $width, $height);
	}
	
}

class Feedee_Youtube_Video extends Feedee_Entry
{
	private $entry;
	private $link;

	public $width = 640;
	public $height = 385;

	public function __construct($json, $link)
	{
		$this->entry = json_decode($json);
		$this->link = $link;
	}

	public function getTitle()
	{
		return $this->entry->title;
	}

	public function getHtml()
	{
		return $this->entry->html;
	}

	public function getAuthor()
	{
		return $this->entry->author_name;
	}

	public function getHeight()
	{
		return $this->entry->height;
	}

	public function getWidth()
	{
		return $this->entry->width;
	}

	public function getThumbWidth()
	{
		return $this->entry->thumbnail_width;
	}

	public function getThumbHeight()
	{
		return $this->entry->thumbnail_height;
	}

	public function getThumb()
	{
		return $this->entry->thumbnail_url;
	}
	
	public function getEmbed($width=null, $height=null)
	{
		if (is_null($width))
			$width = $this->width;
		if (is_null($height))
			$height = $this->height;
		return Feedee_Youtube_Tools::getEmbed(Feedee_Youtube_Tools::getVideoId($this->link), $width, $height);
	}

}

class Feedee_Youtube_Tools
{

	public static function getEmbed($videoId, $width, $height)
	{
		return sprintf('<object width="%1$s" height="%2$s">
			<param name="movie" value="http://www.youtube.com/v/%3$s?fs=1&amp;hl=pt_BR&amp;rel=0"></param>
			<param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param>
			<embed src="http://www.youtube.com/v/%3$s?fs=1&amp;hl=pt_BR&amp;rel=0" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="%1$s" height="%2$s"></embed>
			</object>', $width, $height, $videoId);
	}

	public static function getVideoId($videoUrl)
	{
		preg_match('/http\:\/\/www\.youtube\.com\/watch\?v\=([^\&]*)/', $videoUrl, $matches);
		return $matches[1];
	}

}