<?php

/**
 * 
 * Copyright (c) 2010, eBussola.com All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the eBussola.com.
 * 4. Neither the name of the eBussola.com nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY EBUSSOLA.COM ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL EBUSSOLA.COM BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * configs:
 *		url: string;
 * 
 * @author Leonardo Branco Shinagawa <leonardo@ebussola.com>
 *
 */
class Feedee_Wordpress implements IteratorAggregate
{

	private $channel;
	private $config;
	private $entries;
	
	public function __construct($config)
	{
		$this->config = $config;
		$this->getFeed();
	}
	
	private function getFeed()
	{
		if (isset($this->config['url']))
		{
			$url = $this->config['url'];
                        $expire = isset($this->config['expire']) ? $this->config['expire'] : 21600;
			$xml = Feedee::xml2assoc(Feedee::getHttp($url, $expire));
			$this->channel = $xml[0]['value'][0]['value'];
			foreach ($this->channel as $item)
				if ($item['tag'] == 'item')
					$this->entries[] = new Feedee_Wordpress_Entry($item['value']);
		}
	}
	
	public function getIterator()
	{
		return new ArrayIterator($this->entries);
	}
	
}

class Feedee_Wordpress_Entry extends Feedee_Entry
{
	
	private $entry;
	
	public function __construct($entry)
	{
		$this->entry = $entry;
	}
	
	public function getTitle()
	{
		return $this->entry[0]['value'][0];
	}

	public function getLink()
	{
		return $this->entry[1]['value'][0];
	}
	
	public function getPubDate()
	{
		return $this->entry[3]['value'][0];
	}

	public function getDescription()
	{
		return $this->entry[7]['value'][0];
	}

	public function getContent()
	{
		return $this->entry[8]['value'][0];
	}

	public function getImage()
	{
		preg_match('/.*\<img.*src="([^"]+)/', $this->content, $matches);
		return isset($matches[1]) ? $matches[1] : False;
	}

	public function getVideo($width=null, $height=null)
	{
		preg_match('/.*\<object(.*)<\/object>.*/', $this->content, $matches);
		if (!isset($matches[1]))
		    return False;
		$object = '<object '.$matches[1].'</object>';
		if (!is_null($width))
		  $object = preg_replace('/width=\"([^"]+)/', 'width="'.$width, $object);
		if (!is_null($height))
		  $object = preg_replace('/height=\"([^"]+)/', 'height="'.$height, $object);
		return $object;
	}
	
}