<?php
/* 
 * Copyright (c) 2010, Pura Comunicação [http://www.puracomunicacao.com.br]
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the Pura Comunicação.
 * 4. Neither the name of the Pura Comunicação nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY PURA COMUNICAÇÃO ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PURA COMUNICAÇÃO BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Description of Weather
 *
 * @author Leonardo Branco Shinagawa <leonardo@puracomunicacao.com.br>
 */
class Feedee_Weather {

        private $config;
        private $url = 'http://xoap.weather.com/weather/local/%s?par=%s&key=%s&cc=*&unit=m';

        public function  __construct($config)
        {
                $this->config = $config;
        }
        
        public function getFeed()
        {
                if (isset($this->config['partnerid']) && isset($this->config['licensekey']) && isset($this->config['locationid']))
                {
                        $url = sprintf($this->url, $this->config['locationid'], $this->config['partnerid'], $this->config['licensekey']);
                        if (isset($this->config['forecast']))
                                $url .= '&dayf='.$this->config['forecast'];
                        $expire = isset($this->config['expire']) ? $this->config['expire'] : 1800;
                        $xml = simplexml_load_string(Feedee::getHttp($url, $expire));
                        return new Feedee_Weather_Entry($xml);
                }
        }

        public function request()
        {
                return $this->getFeed();
        }

}


class Feedee_Weather_Entry extends Feedee_Entry
{
        
        private $entry;

        public function  __construct($entry)
        {
                $this->entry = $entry;
        }

        public function getLocation_name()
        {
                return (string) $this->entry->loc->dnam;
        }

        public function getTemperature()
        {
                return (string) $this->entry->cc->tmp;
        }

        public function getForecasts()
        {
                $iterator = new ArrayIterator(array());
                foreach ($this->entry->dayf->day as $day)
                        $iterator->append(new Feedee_Weather_Forecast_Entry($day));
                return $iterator;
        }

}

class Feedee_Weather_Forecast_Entry extends Feedee_Entry
{
        
        private $entry;

        public function  __construct($entry)
        {
                $this->entry = $entry;
        }

        public function getHi()
        {
                return $this->entry->hi;
        }

        public function getLow()
        {
                return $this->entry->low;
        }

        public function getDayIcon()
        {
                return $this->entry->part[0]->icon;
        }

        public function getNightIcon()
        {
                return $this->entry->part[1]->icon;
        }

}