<?php

/**
 * 
 * Copyright (c) 2010, eBussola.com All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the eBussola.com.
 * 4. Neither the name of the eBussola.com nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY EBUSSOLA.COM ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL EBUSSOLA.COM BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * configs:
 *   user:string
 *   set:string
 * 
 * @author Leonardo Branco Shinagawa <leonardo@ebussola.com>
 *
 */
class Feedee_Flickr implements IteratorAggregate
{
	
	private $url = 'http://api.flickr.com/services/feeds/photos_public.gne?id=%s&lang=en-us&format=rss_200';
	private $urlSet = 'http://api.flickr.com/services/feeds/photoset.gne?set=%s&nsid=%s&lang=en-us';
	private $config;
	private $entries;
	
	public function __construct($config)
	{
		$this->config = $config;
		$this->getFeed();
	}
	
	private function getFeed()
	{
		if (isset($this->config['user']) && !is_null($this->config['user']))
        {
            if (isset($this->config['set']) && !is_null($this->config['set']))
            {
                $url = sprintf($this->urlSet, $this->config['set'], $this->config['user']);
                $expire = isset($this->config['expire']) ? $this->config['expire'] : 3600;
                $xml = simplexml_load_string(Feedee::getHttp($url, $expire));
                $this->entries = new ArrayIterator(array());
                foreach ($xml->entry as $entry)
                    $this->entries->append(new Feedee_Flickr_EntrySet($entry));
            }
            else
            {
                $url = sprintf($this->url, $this->config['user']);
                $expire = isset($this->config['expire']) ? $this->config['expire'] : 3600;
                $xml = simplexml_load_string(Feedee::getHttp($url, $expire));
                $this->entries = new ArrayIterator(array());
                foreach ($xml->channel->item as $entry)
                    $this->entries->append(new Feedee_Flickr_Entry($entry));
            }
        }
	}
	
	public function getIterator()
	{
		return $this->entries;
	}
	
}

class Feedee_Flickr_Entry extends Feedee_Entry
{
    private $entry;

    public function __construct($entry)
    {
        $this->entry = $entry;
    }

    public function getTitle()
    {
        return $this->entry->title;
    }

    public function getLink()
    {
        return $this->entry->link;
    }

    public function getSrc()
    {
        $content = (string) $this->entry->description;
        preg_match('/\<img([^\>]*)/', $content, $matches);
        list($empty, $src, $width, $height, $alt) = explode(' ', $matches[1]);
        $src = str_replace('src=', '', $src);
        $src = str_replace('"', '', $src);
        return $src;
    }

    public function getSmall()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 's';
        return $src;
    }

    public function getMedium()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'm';
        return $src;
    }

    public function getBig()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'b';
        return $src;
    }

    public function getOriginal()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'o';
        return $src;
    }
}

class Feedee_Flickr_EntrySet extends Feedee_Entry
{
    private $entry;

    public function __construct($entry)
    {
        $this->entry = $entry;
    }

    public function getTitle()
    {
        return $this->entry->title;
    }

    public function getLink()
    {
        foreach ($this->entry->link as $link)
        {
            if ($link->attributes()->rel == 'alternate')
                return (string) $link->attributes()->href;
        }
    }

    public function getSrc()
    {
        foreach ($this->entry->link as $link)
        {
            if ($link->attributes()->rel == 'enclosure')
                return (string) $link->attributes()->href;
        }
    }

    public function getSmall()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 's';
        return $src;
    }

    public function getMedium()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'm';
        return $src;
    }

    public function getBig()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'b';
        return $src;
    }

    public function getOriginal()
    {
        $src = $this->src;
        $pos = strpos($src, '.jpg');
        $src[$pos-1] = 'o';
        return $src;
    }

    public function getThumb()
    {
        $content = (string) $this->entry->content;
        $img = preg_match('/\<img([^\>]*)/', $content, $matches);
        list($empty, $src, $width, $height, $alt) = explode(' ', $matches[1]);
        $src = str_replace('src=', '', $src);
        $src = str_replace('"', '', $src);
        return $src;
    }

    public function getThumb_width()
    {
        $content = (string) $this->entry->content;
        $img = preg_match('/\<img([^\>]*)/', $content, $matches);
        list($empty, $src, $width, $height, $alt) = explode(' ', $matches[1]);
        $width = str_replace('width=', '', $width);
        $width = str_replace('"', '', $width);
        return $width;
    }

    public function getThumb_height()
    {
        $content = (string) $this->entry->content;
        $img = preg_match('/\<img([^\>]*)/', $content, $matches);
        list($empty, $src, $width, $height, $alt) = explode(' ', $matches[1]);
        $height = str_replace('height=', '', $height);
        $height = str_replace('"', '', $height);
        return $height;
    }
    
}