﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{

    private static int personcount = 1;
    private static Random rnd = new Random();

    public class Person
    {
        public int ID { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string Phone { get; set; }
        public string Email { get; set; }
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        List<Person> persons = new List<Person>();
        for (int i = 0; i < 40; i++)
            persons.Add(CreateRndPerson());
        gridView.DataSource = persons;
        gridView.DataBind();

    }

    protected Person CreateRndPerson()
    {
        Person p = new Person();
        p.ID = personcount++;
        p.FirstName = CreateRndString(3, 6);
        p.LastName = CreateRndString(4, 8);
        p.Email = p.FirstName + "." + p.LastName + "@" + CreateRndString(3, 7) + ".com";

        return p;
    }

    protected string CreateRndString(int min, int max)
    {
        string n = "";
        int len = rnd.Next(min, max);
        n += (char)(65 + rnd.Next(0, 26));
        for (int i = 1; i < len; i++)
        {
            n += (char)(97 + rnd.Next(0, 26));
        }
        return n;
    }
}
