﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace ExpressionEngine.ValueProviders
{
    public class ReflectionValueProvider: IValueProvider
    {
        private readonly object _object;
        private static Dictionary<string, PropertyInfo> _propertyInfoCache = new Dictionary<string, PropertyInfo>();

        public ReflectionValueProvider(object obj)
        {
            _object = obj;
        }

        public double GetValue(string propertyName)
        {
            string propertyKey = string.Format("{0} - {1}", _object.GetType().FullName, propertyName);
            if (!_propertyInfoCache.ContainsKey(propertyKey))
                _propertyInfoCache[propertyKey] = _object.GetType().GetProperty(propertyName);

            return Convert.ToDouble(_propertyInfoCache[propertyKey].GetValue(_object, null));
        }
    }
}
