﻿namespace ExpressionEngine
{
    internal abstract class BaseAggregateState
    {
        public BaseAggregateState(string entry)
        {
            OriginalEntry = entry;
            int expressionStartsFrom = entry.IndexOf('(') + 1;
            string subExpression = entry.Substring(expressionStartsFrom, entry.Length - expressionStartsFrom - 1);
            Expression = new ExpressionEveluator(subExpression);
        }

        public string OriginalEntry { get; private set; }
        public ExpressionEveluator Expression { get; private set; }

        public abstract void Reset();
        public abstract double GetResult();

        public virtual void RowChanged(IValueProvider valueProvider)
        {
            AddValue(Expression.Evaluate(valueProvider));
        }

        protected abstract void AddValue(double value);
    }
}
