﻿namespace ExpressionEngine.AggregateFunctions
{
    internal class SumState : BaseAggregateState
    {
        private double _sum = 0;

        public SumState(string entry) : base(entry) { }

        public override void Reset()
        {
            _sum = 0;
        }

        protected override void AddValue(double value)
        {
            _sum += value;
        }

        public override double GetResult()
        {
            return _sum;
        }
    }
}
