﻿using System;

namespace ExpressionEngine.AggregateFunctions
{
    internal class MinState : BaseAggregateState
    {
        private double? _min = null;

        public MinState(string entry) : base(entry) { }

        public override void Reset()
        {
            _min = null;
        }

        protected override void AddValue(double value)
        {
            if (_min.HasValue)
            {
                _min = Math.Min(_min.Value, value);
            }
            else
                _min = value;
        }

        public override double GetResult()
        {
            return _min.HasValue ? _min.Value : 0;
        }
    }
}
