﻿using System;

namespace ExpressionEngine.AggregateFunctions
{
    internal class MaxState : BaseAggregateState
    {
        private double? _max = null;

        public MaxState(string entry) : base(entry) { }

        public override void Reset()
        {
            _max = null;
        }

        protected override void AddValue(double value)
        {
            if (_max.HasValue)
            {
                _max = Math.Max(_max.Value, value);
            }
            else
                _max = value;
        }

        public override double GetResult()
        {
            return _max.HasValue ? _max.Value : 0;
        }
    }
}
