namespace ExpressionEngine.AggregateFunctions
{
    internal class CountState : BaseAggregateState
    {
        private int _count = 0;

        public CountState(string entry) : base(entry) { }

        public override void Reset()
        {
            _count = 0;
        }

        protected override void AddValue(double value)
        {
            _count++;
        }

        public override void RowChanged(IValueProvider valueProvider) 
        {
            AddValue(0);
        }

        public override double GetResult()
        {
            return _count;
        }
    }
}