﻿namespace ExpressionEngine.AggregateFunctions
{
    internal class AverageState : BaseAggregateState
    {
        private double _sum = 0;
        private int _count = 0;

        public AverageState(string entry) : base(entry) { }

        public override void Reset()
        {
            _sum = 0;
            _count = 0;
        }

        protected override void AddValue(double value)
        {
            _count++;
            _sum += value;
        }

        public override double GetResult()
        {
            if (_count == 0)
                return 0;
            return _sum / _count;
        }
    }
}
