<?php
/**
 * Debug sites live.
 * @author Artur Barseghyan www@foreverchild.info
 * @version 0.2
 * @copyright Artur Barseghyan
 * @license GPL 
 */

/*
 * If you don't use auto loader, you need to require class Debug.php.
 */
// require 'Debug.php';

/*
 * Assigning some variable to test with.
 */
$someVars = array('I', 'try', 'to', 'be', 'smart', '!');
$moreVars = array(array('N', 'o', 'b', 'ody'), 'really knows',
	'who John Doe', 'is', ':)');
$evenMoreVars = $_SERVER;
$evenSomeMoreVars = array(array('127.0.0.1'), 0, 'Some text');


/*
 * Using this class, we can call any PHP function which will only be performed
 * if user passes the security checks, as IP or Fingerprint.
 *
 * So, it's simply Debug::Call()->FunctionName(FunctionArguments). See the
 * following line as an example. So far it will not do anything, since our
 * IP addresses array is empty and IP address check it enabled by default.
 */
echo '----Test 1' . "\n";
Debug::Call()->print_r($someVars);
echo "\n" . '----/Test 1' . "\n\n";


/*
 * It's possible to generate your unique Fingerprint to add it to the code
 * for future use.
 */
echo '----Test 2' . "\n";
echo 'This is a fingerprint: ' . Debug::GenerateFingerprint();
echo "\n" . '----/Test 2' . "\n\n";


/*
 * When you have generated a Fingerprint and want to use it for security checks
 * you shall:
 *		(1) Call <Debug::AddFingerprint('YourFingerprintString')> function;
 *		(2) Register fingerprint check (this is off by default - only IP check
 *		is performed). So simply call <Debug::AddAccessCheck('fingerprint')>.
 *
 * It's possible to add more than one fingerprint.
 */
Debug::AddFingerprint('6aa78fe58ecc0134e86deffa00184c6d83985757');
Debug::AddFingerprint('fdlskflsk58k54eee8fddsa0ffs4gg0459230jkg');
Debug::AddAccessCheck('fingerprint');


/*
 * We can make all content, which would possibly resulted by PHP function calls
 * between html DIV tags.
 *
 * See the following line as an example:
 * <div style="display:none">possible_php_output</div>.
 *
 * If set to false, DIV tags won't appear in the output.
 */
Debug::SetDisplayNone(true);


/*
 * We can also add debug info to the output. Debug info shows:
 *		(1) Function which is called;
 *		(2) Call parameters;
 *		(3) File from which the function is called;
 *		(4) Line from which the function is called.
 *
 * #3 and 4 are shown only if the <Debug::SetAddDebugInfo(true)> was made.
 *
 * See the following line as an example.
 */
Debug::SetAddDebugInfo(true);


/*
 * Now we can try to output a variable. The following line will not output
 * anything, because it won't pass the security checks, since no IP address has 
 * been specified yet.
 *
 * In this call we simply use PHP <print_r> function to print the <$someVars>
 * variable.
 */
echo '----Test 3' . "\n";
Debug::Call()->print_r($moreVars);
echo "\n" . '----/Test 3' . "\n\n";


/*
 * Lets reset fingerprints array by calling <Debug::ResetFingerprints()>
 * function and test it just with IP. I assume you use 127.0.0.1. Otherwise
 * change it to your own IP address.
 */
Debug::ResetFingerprints();


Debug::Call()->include_once(__FILE__);


/*
 * Now we add an IP to test with. It is possible to set more than one IP.
 */
Debug::AddIp('127.0.0.1');
Debug::AddIp('206.190.60.37');


/*
 * If we now want to have IP check only, we shall first remove fingerprint
 * check, which we have added.
 */
Debug::RemoveAccessCheck('fingerprint');


/*
 * Let's define a user function to call.
 */
function myFunction($someString = '') {
	return 'Aaaaaaaaaaaaaa ' . $someString;
}


/* 
 * Now we can make another function call. Note, that calls return the result
 * value as well.
 */
echo '----Test 4' . "\n";
echo Debug::Call()->myFunction('Bbbbbbbbbbbbbb');
echo "\n" . '----/Test 4' . "\n\n";


//Debug::Call()->die(__FILE__);


/*
 * Alternatively, we can also change some parameters inline.
 */
echo '----Test 5' . "\n";
Debug::Call()->showInfo(false)->displayNone(false)->var_dump($evenSomeMoreVars);
echo "\n" . '----/Test 5' . "\n\n";


/*
 * We can also add full trace to our output. Though, it will work only if both
 * <Debug::SetAddDebugInfo()> and <Debug::DisplayFullTrace()> functions were
 * called with true arguments.
 */
Debug::SetDisplayFullTrace(true);


/*
 * If you try to access a non-existing or non-callable function, an error
 * message will be added to your output, but it won't result a fatal error.
 */
echo '----Test 6' . "\n";
Debug::Call()->This_Function_Does_Not_Exist($someVars);
echo "\n" . '----/Test 6' . "\n\n";


/*
 * Let's define a user function to call.
 */
function myAnotherFunction($someString = '') {
	echo 'Aaaaaaaaaaaaaa ' . $someString;
}


/*
 * We could as well use <Debug::UseBuffer()> function to collect all output in
 * the buffer, instead of writing it directly.
 */

echo '----Test 7' . "\n";
Debug::UseBuffer();
Debug::Call()->myAnotherFunction('Bbbbbbbbbbbbbb');
Debug::Call()->print_r($moreVars);
echo "\n" . '----/Test 7' . "\n\n";


/*
 * Here we output the buffer. If we call <Debug::GetBuffer()> function with
 * argument true, we receive result as a String instead of an Array. We need to
 * call a <Debug::NoBuffer()> function when we don't want data to be collected
 * in the buffer anymore.
 */
echo '----Test 8' . "\n";
echo Debug::GetBuffer(true);
Debug::EmptyBuffer();
echo "\n" . '----/Test 8' . "\n\n";


/*
 * Let's define yet another user function to call.
 */
function yetAnotherFunction($someString = '') {
	return array('Aaaaaaaaaaaaaa', $someString);
}


/*
 * By default, in debug info data is dumped using PHP <print_r> function. But
 * we can dump it using <dump_var> as well. For that, we need to call
 * <Debug::SetDumpFunction('var_dump')> function with argument 'var_dump'.
 */
echo '----Test 9' . "\n";
Debug::SetDumpFunction('var_dump'); // Setting var_dump as dump function.
Debug::SetDisplayFullTrace(false); // Setting of previously set full trace.
Debug::SetAddDebugInfo(true); // Settings to display debug info.
Debug::NoBuffer(); // Stop data to be collected in the buffer.
Debug::SetDisplayNone(true);
Debug::Call()->yetAnotherFunction('Bbbbbbbbbbbbbb');
Debug::Call()->print_r($someVars);
echo "\n" . '----/Test 9' . "\n\n";


// Just dump the object to see what it looks like.
echo '----Dumping the debug object before cleaning it up' . "\n";
print_r(Debug::Call());
echo "\n" . '----/Dumping the debug object before cleaning it up' . "\n\n";

/*
 * Finally, there are some reset functions, if you want to globally reset
 * all set values.
 */
Debug::ResetDisplayConfiguration(); // Resets Display None to its' default value.
Debug::ResetDumpFunction(); // Resets dump function to its' default value.
Debug::ResetFingerprints(); // Resets the fingerprints.
Debug::EmptyBuffer(); // Empties the buffer.
Debug::ResetIps(); // Resets IPs


/*
 * It's also possible to call a global reset function, which does all of the
 * above.
 */
Debug::Reset();


// Now we dump the cleaned object.
echo '----Dumping the debug object after cleaning it up' . "\n";
print_r(Debug::Call());
echo "\n" . '----/Dumping the debug object after cleaning it up' . "\n\n";

/*
 * See the class itself for more functionality. I tried to write comments by
 * each function.
 */
?>