<?php
// Include the class file
require_once('class.debug.php');

// Start the class
$debug = NEW Debug();

// Include the helper functions
require_once('functions.php');

/*
 * The debug class requires $_SESSION['debug'] to be set to output.
 * The reason for this is simple, on a live site you can still leave all
 * of your debugs turned on. To a user, no debug information is shown.
 * But when you log in, you can simply add ?debug=1 to the URL and it
 * will set the session variable!
 *
 */

//if (isset($_GET['debug']))
    $_SESSION['debug'] = TRUE;

// Include the demo files
include('example/header.php');
include('example/example_include.php');

$test_array = array('colors'=>array('blue', 'green', 'red'), 'fruit'=>array('apples'=>array('granny smith', 'red'), 'oranges', 'bananas'));

    // Simple "I'm here!" test
    debug();

    // Basic string
    debug('This is a test string');

    // String with a different color
    debug('This is a test string with color', 'blue');

    // String with a hexidecimal color
    debug('This is a test string with a hex color', '#123456');

    // Array
    debug($test_array);

    // Object
    debug($debug);

    // Send variable to email - VERY useful for debugging ajax or between redirects
    //debug_mail($test_array, 'me@here.com');



// Include the demo files
include('example/footer.php');



// Output the debug information
$debug->output();

?>
