<?php
/**
 * @author  : Aaron Weatherall <aaron@zencode.com.au>
 * @date    : 2011-03-24
 * @desc    : A life saving class for web developers to easily debug information on the page.
 * @version : v0.1
 * @license : GPL
 */

class Debug {

    public $defaultcolor = '#ff0000';
    public $items = array();
    public $debugger;

    function add($message = NULL, $color = NULL) {

        // If no color set
        if (is_null($color)) $color = $this->defaultcolor;

        if (is_null($message)) $message = "I'm HERE!";

        $type = 'string';

        if ( is_array($message) )$type = 'array';
        if ( is_object($message) ) {
            $message = $this->objectToArray ($message);
            $type = 'object';
        }

        // Get Page
        @trigger_error('test', E_USER_NOTICE);
        $errorDetails = debug_backtrace();
        $page = $errorDetails[1]['file'];

        $error = array('page'=>$page, 'message'=>serialize($message), 'line'=>$errorDetails[1]['line'], 'color'=>$color, 'type'=>$type);
        if (isset($this->items[$page]))
            array_push($this->items[$page], $error);
        else $this->items[$page][0] = $error;
    }

    function output() {

        if (empty($this->items)) return false;
        if (isset($_SESSION['debug'])) {
            $i = 1;
            echo '<div style="width:940px; margin: 0 auto; background-color: white; margin-top: 20px; border: 1px solid black; color: black; padding: 20px;margin-bottom: 40px;">' . "\r\n";
            echo "\t" . '<h1 style="font-size: 28px; font-family: arial; margin-bottom: 20px;">Debug Window</h1>'."\r\n";
            echo "\t" . '<p>If you can see this, it means our developers are hard at work and have forgotten to turn this off. <strong>Don\'t worry, you haven\'t broken anything</strong>. If you were placing an order or saving details, your information has been saved as per normal. Move along.. nothing more to see here.</p>'."\r\n";
            foreach ($this->items as $k=>$item) {
                echo "\t" . '<div style="background-color: #eee; padding: 10px;margin-bottom: 40px; width: 920px;">'."\r\n";
                echo "\t\t" . '<h2 style="font-weight: bolder; font-size: 18px; color: black; padding-bottom: 10px; border-bottom: 1px solid black; margin-bottom: 10px;">#1' . $i . ': ' . $k.'</h2>'."\r\n";
                foreach ($item as $error) {
                    $message = unserialize($error['message']);
                    if (is_array($message)) echo $this->dumpArray($message, $error['line'], $error['color'], $error['type']);
                    else echo $this->dumpVariable($message, $error['line'], $error['color'], $error['type']);
                }
                $i++;
                echo "\t" . "</div>" . "\r\n";
            }
            echo '</div>'. "\r\n";
        }
    }

    function dumpArray($array, $line, $color, $type) {

        if (empty($array)) return $this->dumpVariable('Array empty', $line, $color, $type);

        $output = $this->echo_array($array);

        $return = "\t\t" . "<div style='font-family:courier;'>" . "\r\n";
        $return .= "\t\t\t" . "<span style='padding:5px;font-weight: bolder;font-family:arial;background-color: $color; color: white;'>" . ucfirst($type). " Dump on Line ($line)-></span>" . "\r\n";
        $return .= "\t\t\t" . "<br style='clear:both;' />" . "\r\n";
        $return .= "\t\t\t" . "<br />". "\r\n";
        $return .= $output;
        $return .= "\t\t\t" . "<br />". "\r\n";
        $return .= "\t\t\t" . "<span style='font-weight: bolder;font-family:arial;padding:5px;background-color: $color; color: white;'><-</span>". "\r\n";
        $return .= "\t\t" . "</div>". "\r\n";
        $return .= "\t\t" . "<br />". "\r\n";
        return $return;
    }

    function dumpVariable($variable, $line, $color, $type) {

        return "<div style='font-family:courier;'><span style='padding:5px;font-weight: bolder;font-family:arial;background-color: $color; color: white;'>Variable Dump on Line ($line)-></span> " . $variable. " <span style='font-weight: bolder;margin-top: 10px;font-family:arial;background-color: $color; padding:5px;color: white;'><-</span></div><br />";

    }

    function echo_array($array){

        $return = '';
        if(is_array($array) == false) return "The provided variable is not an array.";

        $return = "\t\t\t" . "<div><div style='margin-left:20px;'>" . "\r\n";
        foreach($array as $name=>$value){
            if(is_array($value)){
                $return .= "\t\t\t\t" . "['<strong style='font-size: 14px;'>$name</strong>'] = Array {<div style='margin-left:20px;'>\n";
                $return .= $this->echo_array($value);
                $return .= "\t\t\t\t" . "</div>}";
                $return .= "<br />" . "\r\n";
            }else{
                if(is_string($value)){
                    $value = "\t\t\t\t" . "$value";
                }
                $return .= "\t\t\t\t" . "['<strong style='color: #8F6264;'>$name</strong>'] => " . $this->html2txt(html_entity_decode(trim($this->nl2br2($value)))) . "\r\n";
                $return .=  "<br />" . "\r\n";
            }
        }
        $return .= "\t\t\t" . "</div></div>". "\r\n";

        return $return;
    }

    function echo_object($array){

        $return = '';

        $array = $this->objectToArray($array);
        $return = "\t\t\t" . "<div><div style='margin-left:20px;'>" . "\r\n";
        foreach($array as $name=>$value){
            $value = unserialize($value);
            if(is_array($value)){
                $return .= "\t\t\t\t" . "['<strong style='font-size: 14px;'>$name</strong>'] = Array {<div style='margin-left:20px;'>\n";
                $return .= $this->echo_array($value);
                $return .= "\t\t\t\t" . "</div>}";
                $return .= "<br />" . "\r\n";
            }else{
                if(is_string($value)){
                    $value = "\t\t\t\t" . "$value";
                }
                $return .= "\t\t\t\t" . "['<strong style='color: #8F6264;'>$name</strong>'] => " . $this->html2txt(html_entity_decode(trim($this->nl2br2($value)))) . "\r\n";
                $return .=  "<br />" . "\r\n";
            }
        }
        $return .= "\t\t\t" . "</div></div>". "\r\n";

        return $return;
    }

    function testMail($message, $to = NULL) {

	if (is_null($to)) {
	    $this->addDebug('No Email specified', 'blue');
	    return false;
	}

	if (is_array($message)) $message = print_r($message,1);
	mail($to, 'Debug Email', $message);

	$this->addDebug('Debug Email Sent', 'blue');
	$this->addDebug($message, 'blue');
    }

    private function objectToArray( $object ) {
        if( !is_object( $object ) && !is_array( $object ) ) return $object;
        if( is_object( $object ) ) $object = get_object_vars( $object );
        return array_map( array($this, 'objectToArray'), $object );
    }

    private function nl2br2($string) {
        $string = str_replace(array("\r\n", "\r", "\n", "\t"), "", $string);
        return $string;
    }

    private function html2txt( $document ) {
        $search = array('@<script[^>]*?>.*?</script>@si',  // Strip out javascript
                        '@<style[^>]*?>.*?</style>@siU', // Strip style tags properly
                        '@<[\/\!]*?[^<>]*?>@si', // Strip out HTML tags
                        '@<![\s\S]*?--[ \t\n\r]*>@' // Strip multi-line comments including CDATA
        );
	$text = preg_replace($search, '', $document);
	return $text;
    }

}

?>