<?php
/*
---------------------------------------------------------------------
Site Navigation class
    - A PHP class which lets you build a dynamic site navigation bar
---------------------------------------------------------------------

This source file is released under LGPL license, available through 
the world wide web at, http://www.gnu.org/copyleft/lesser.html. This 
library is distributed WITHOUT ANY WARRANTY. Please see the LGPL for 
more details.

PLEASE READ THE README FILE, for more details on how to use this 
library.

COMPATIBILITY NOTE: At the moment, this library is experimental and 
designed to work only with PHP4 and above. 

---------------------------------------------------------------------
Author: Andi Trinculescu <andi@lizard.ro>
---------------------------------------------------------------------
*/

class Navigation {
    var $nav = array();
    var $level = 0;    
    
    function setLevel($level) {
        $this->level = $level;
    }
    
    function push($link, $text, $level = -1) {
        $nav = array();
        $this->level = ($level >= 0) ? $level : $this->level;
        for($i = 0; $i < $this->level; $i++) {
            $nav[] = $this->nav[$i];            
        }
        array_push($nav, array( 'link'  => $link, 'text'  => $text));
        $this->nav = $nav;
    }
    
    function pop() {
        array_pop($this->nav);
    }
    
    function html() {
        reset($this->nav);
        $html = '<p class="breadcrumb">';
        for($i = 0; $i <= $this->level; $i++) {
            if ($i == $this->level) {
                $html .= '<span class="breadcrumbcurrent">' . $this->nav[$i]['text'] . '</span>';
            }
            else {
                $html .= '<a href="' . $this->nav[$i]['link'] . '">' . $this->nav[$i]['text'] . '</a>&nbsp;>&nbsp;';
            }
        }
        $html .= "</p>\n";
        
        return $html;
    }
}
?>